/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.bgt.schema;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import nl.b3p.brmo.bgt.schema.BGTObjectType;
import nl.b3p.brmo.schema.Schema;
import nl.b3p.brmo.schema.mapping.AttributeColumnMapping;
import nl.b3p.brmo.schema.mapping.BooleanAttributeColumnMapping;
import nl.b3p.brmo.schema.mapping.DoubleAttributeColumnMapping;
import nl.b3p.brmo.schema.mapping.GeometryAttributeColumnMapping;
import nl.b3p.brmo.schema.mapping.IntegerAttributeColumnMapping;
import nl.b3p.brmo.schema.mapping.OneToManyColumnMapping;
import nl.b3p.brmo.schema.mapping.SimpleDateFormatAttributeColumnMapping;

public class BGTSchema
extends Schema {
    private static BGTSchema instance;
    public static final String EIND_REGISTRATIE = "eindRegistratie";
    static final Set<String> bgtObjectTypes;
    private static final List<AttributeColumnMapping> bgtBaseAttributes;

    private List<AttributeColumnMapping> withBaseAttributes(AttributeColumnMapping ... attributes) {
        return Stream.concat(bgtBaseAttributes.stream(), Stream.of(attributes)).collect(Collectors.toList());
    }

    public BGTSchema() {
        this.addObjectType(new BGTObjectType(this, "Bak", this.withBaseAttributes(new AttributeColumnMapping("function"), new AttributeColumnMapping("plus-type"), new GeometryAttributeColumnMapping("geometrie2dBak", "geometry(POINT, 28992)"))));
        this.addObjectType(new BGTObjectType(this, "PlantCover", this.withBaseAttributes(new AttributeColumnMapping("plus-fysiekVoorkomen"), new AttributeColumnMapping("class"), new BooleanAttributeColumnMapping("begroeidTerreindeelOpTalud", false), new GeometryAttributeColumnMapping("geometrie2dBegroeidTerreindeel"), new GeometryAttributeColumnMapping("kruinlijnBegroeidTerreindeel"))));
        this.addObjectType(new BGTObjectType(this, "Bord", this.withBaseAttributes(new AttributeColumnMapping("function"), new AttributeColumnMapping("plus-type"), new GeometryAttributeColumnMapping("geometrie2dBord", "geometry(POINT, 28992)"))));
        this.addObjectType(new BGTObjectType(this, "Buurt", this.withBaseAttributes(new AttributeColumnMapping("naam", "varchar(255)", false), new AttributeColumnMapping("buurtcode"), new AttributeColumnMapping("wijk", "varchar(255)", false), new GeometryAttributeColumnMapping("geometrie2d"))));
        this.addObjectType(new BGTObjectType(this, "FunctioneelGebied", this.withBaseAttributes(new AttributeColumnMapping("naam", "varchar(255)", false), new AttributeColumnMapping("bgt-type"), new AttributeColumnMapping("plus-type"), new GeometryAttributeColumnMapping("geometrie2dFunctioneelGebied"))));
        this.addObjectType(new BGTObjectType(this, "BuildingInstallation", this.withBaseAttributes(new AttributeColumnMapping("function"), new AttributeColumnMapping("plus-typeGebouwInstallatie"), new GeometryAttributeColumnMapping("geometrie2dGebouwInstallatie"))));
        this.addObjectType(new BGTObjectType(this, "Installatie", this.withBaseAttributes(new AttributeColumnMapping("function"), new AttributeColumnMapping("plus-type"), new GeometryAttributeColumnMapping("geometrie2dInstallatie", "geometry(POINT, 28992)"))));
        this.addObjectType(new BGTObjectType(this, "Kast", this.withBaseAttributes(new AttributeColumnMapping("function"), new AttributeColumnMapping("plus-type"), new GeometryAttributeColumnMapping("geometrie2dKast", "geometry(POINT, 28992)"))));
        this.addObjectType(new BGTObjectType(this, "Kunstwerkdeel", this.withBaseAttributes(new AttributeColumnMapping("bgt-type"), new AttributeColumnMapping("plus-type"), new GeometryAttributeColumnMapping("geometrie2dOverigeConstructie"))));
        this.addObjectType(new BGTObjectType(this, "Mast", this.withBaseAttributes(new AttributeColumnMapping("function"), new AttributeColumnMapping("plus-type"), new GeometryAttributeColumnMapping("geometrie2dMast", "geometry(POINT, 28992)"))));
        this.addObjectType(new BGTObjectType(this, "OnbegroeidTerreindeel", this.withBaseAttributes(new AttributeColumnMapping("bgt-fysiekVoorkomen"), new AttributeColumnMapping("plus-fysiekVoorkomen"), new BooleanAttributeColumnMapping("onbegroeidTerreindeelOpTalud", false), new GeometryAttributeColumnMapping("geometrie2dOnbegroeidTerreindeel"), new GeometryAttributeColumnMapping("kruinlijnOnbegroeidTerreindeel"))));
        this.addObjectType(new BGTObjectType(this, "OndersteunendWaterdeel", this.withBaseAttributes(new AttributeColumnMapping("class"), new AttributeColumnMapping("plus-type"), new GeometryAttributeColumnMapping("geometrie2dOndersteunendWaterdeel"))));
        this.addObjectType(new BGTObjectType(this, "AuxiliaryTrafficArea", this.withBaseAttributes(new AttributeColumnMapping("function"), new AttributeColumnMapping("surfaceMaterial"), new AttributeColumnMapping("plus-functieOndersteunendWegdeel"), new AttributeColumnMapping("plus-fysiekVoorkomenOndersteunendWegdeel"), new BooleanAttributeColumnMapping("ondersteunendWegdeelOpTalud", false), new GeometryAttributeColumnMapping("geometrie2dOndersteunendWegdeel"), new GeometryAttributeColumnMapping("kruinlijnOndersteunendWegdeel"))));
        this.addObjectType(new BGTObjectType(this, "OngeclassificeerdObject", this.withBaseAttributes(new GeometryAttributeColumnMapping("geometrie2d"))));
        this.addObjectType(new BGTObjectType(this, "OpenbareRuimte", this.withBaseAttributes(new GeometryAttributeColumnMapping("geometrie2d"))));
        this.addObjectType(new BGTObjectType(this, "OpenbareRuimteLabel", this.withBaseAttributes(new IntegerAttributeColumnMapping("idx", true, true), new AttributeColumnMapping("tekst"), new DoubleAttributeColumnMapping("hoek"), new GeometryAttributeColumnMapping("plaatsingspunt", "geometry(POINT, 28992)"), new AttributeColumnMapping("openbareRuimteType"), new AttributeColumnMapping("identificatieBAGOPR", "varchar(16)", false))));
        this.addObjectType(new BGTObjectType(this, "BridgeConstructionElement", this.withBaseAttributes(new BooleanAttributeColumnMapping("overbruggingIsBeweegbaar", false), new AttributeColumnMapping("hoortBijTypeOverbrugging"), new AttributeColumnMapping("class"), new AttributeColumnMapping("identificatieBAGOPR", "varchar(16)", false), new GeometryAttributeColumnMapping("geometrie2dOverbruggingsdeel"))));
        this.addObjectType(new BGTObjectType(this, "OverigBouwwerk", this.withBaseAttributes(new AttributeColumnMapping("bgt-type"), new AttributeColumnMapping("plus-type"), new GeometryAttributeColumnMapping("geometrie2dOverigeConstructie"))));
        this.addObjectType(new BGTObjectType(this, "OverigeScheiding", this.withBaseAttributes(new AttributeColumnMapping("plus-type", "varchar(255)", false), new GeometryAttributeColumnMapping("geometrie2dOverigeConstructie"))));
        this.addObjectType(new BGTObjectType(this, "Paal", this.withBaseAttributes(new AttributeColumnMapping("function"), new AttributeColumnMapping("plus-type", "varchar(255)", false), new AttributeColumnMapping("hectometeraanduiding", "varchar(255)", false), new GeometryAttributeColumnMapping("geometrie2dPaal", "geometry(POINT, 28992)"))));
        this.addObjectType(new BGTObjectType(this, "BuildingPart", this.withBaseAttributes(new AttributeColumnMapping("identificatieBAGPND"), new OneToManyColumnMapping("nummeraanduidingreeks"), new GeometryAttributeColumnMapping("geometrie2dGrondvlak"))));
        this.addObjectType(new BGTObjectType(this, "nummeraanduidingreeks", Arrays.asList(new AttributeColumnMapping("pandgmlid", "varchar(255)", true, true), new IntegerAttributeColumnMapping("idx", true, true), new BooleanAttributeColumnMapping("pandeindregistratie", true), new AttributeColumnMapping("tekst"), new DoubleAttributeColumnMapping("hoek"), new GeometryAttributeColumnMapping("plaatsingspunt", "geometry(POINT, 28992)"), new AttributeColumnMapping("identificatieBAGVBOLaagsteHuisnummer", "varchar(16)", false), new AttributeColumnMapping("identificatieBAGVBOHoogsteHuisnummer", "varchar(16)", false))));
        this.addObjectType(new BGTObjectType(this, "Plaatsbepalingspunt", Arrays.asList(new AttributeColumnMapping("gmlId", "char(32)", true, true), new AttributeColumnMapping("identificatie"), new IntegerAttributeColumnMapping("nauwkeurigheid", false), new SimpleDateFormatAttributeColumnMapping("datumInwinning", "date", true, "yyyy-MM-dd"), new AttributeColumnMapping("inwinnendeInstantie", "varchar(255)", false), new AttributeColumnMapping("inwinningsmethode", "varchar(255)", true), new GeometryAttributeColumnMapping("geometrie", "geometry(POINT, 28992)"))));
        this.addObjectType(new BGTObjectType(this, "Put", this.withBaseAttributes(new AttributeColumnMapping("function"), new AttributeColumnMapping("plus-type"), new GeometryAttributeColumnMapping("geometrie2dPut", "geometry(POINT, 28992)"))));
        this.addObjectType(new BGTObjectType(this, "Scheiding", this.withBaseAttributes(new AttributeColumnMapping("bgt-type"), new AttributeColumnMapping("plus-type"), new GeometryAttributeColumnMapping("geometrie2dOverigeConstructie"))));
        this.addObjectType(new BGTObjectType(this, "Sensor", this.withBaseAttributes(new AttributeColumnMapping("function"), new AttributeColumnMapping("plus-type"), new GeometryAttributeColumnMapping("geometrie2dSensor"))));
        this.addObjectType(new BGTObjectType(this, "Railway", this.withBaseAttributes(new AttributeColumnMapping("function"), new AttributeColumnMapping("plus-functieSpoor", "varchar(255)", false), new GeometryAttributeColumnMapping("geometrie2dSpoor"))));
        this.addObjectType(new BGTObjectType(this, "Stadsdeel", this.withBaseAttributes(new AttributeColumnMapping("naam", "varchar(255)", false), new AttributeColumnMapping("function", "varchar(255)", false), new GeometryAttributeColumnMapping("geometrie2d"))));
        this.addObjectType(new BGTObjectType(this, "Straatmeubilair", this.withBaseAttributes(new AttributeColumnMapping("function"), new AttributeColumnMapping("plus-type"), new GeometryAttributeColumnMapping("geometrie2dStraatmeubilair", "geometry(POINT, 28992)"))));
        this.addObjectType(new BGTObjectType(this, "TunnelPart", this.withBaseAttributes(new GeometryAttributeColumnMapping("geometrie2dTunneldeel"))));
        this.addObjectType(new BGTObjectType(this, "SolitaryVegetationObject", this.withBaseAttributes(new AttributeColumnMapping("class"), new AttributeColumnMapping("plus-type"), new GeometryAttributeColumnMapping("geometrie2dVegetatieObject"))));
        this.addObjectType(new BGTObjectType(this, "Waterdeel", this.withBaseAttributes(new AttributeColumnMapping("class"), new AttributeColumnMapping("plus-type"), new GeometryAttributeColumnMapping("geometrie2dWaterdeel"))));
        this.addObjectType(new BGTObjectType(this, "Waterinrichtingselement", this.withBaseAttributes(new AttributeColumnMapping("function"), new AttributeColumnMapping("plus-type"), new GeometryAttributeColumnMapping("geometrie2dWaterinrichtingselement"))));
        this.addObjectType(new BGTObjectType(this, "Waterschap", this.withBaseAttributes(new GeometryAttributeColumnMapping("geometrie2d"))));
        this.addObjectType(new BGTObjectType(this, "TrafficArea", this.withBaseAttributes(new AttributeColumnMapping("function"), new AttributeColumnMapping("plus-functieWegdeel"), new AttributeColumnMapping("plus-fysiekVoorkomenWegdeel"), new AttributeColumnMapping("surfaceMaterial"), new BooleanAttributeColumnMapping("wegdeelOpTalud", false), new GeometryAttributeColumnMapping("geometrie2dWegdeel"), new GeometryAttributeColumnMapping("kruinlijnWegdeel"))));
        this.addObjectType(new BGTObjectType(this, "Weginrichtingselement", this.withBaseAttributes(new AttributeColumnMapping("function"), new AttributeColumnMapping("plus-type"), new GeometryAttributeColumnMapping("geometrie2dWeginrichtingselement"))));
        this.addObjectType(new BGTObjectType(this, "Wijk", this.withBaseAttributes(new AttributeColumnMapping("naam", "varchar(255)", false), new AttributeColumnMapping("wijkcode"), new GeometryAttributeColumnMapping("geometrie2d"))));
    }

    protected void addObjectType(BGTObjectType objectType) {
        super.addObjectType(objectType);
    }

    public static BGTSchema getInstance() {
        if (instance == null) {
            instance = new BGTSchema();
        }
        return instance;
    }

    public Stream<BGTObjectType> getAllObjectTypes() {
        return super.getAllObjectTypes();
    }

    public Stream<BGTObjectType> getOnlyBGTObjectTypes() {
        return this.getAllObjectTypes().filter(objectType -> !objectType.isIMGeoPlusType());
    }

    public Stream<BGTObjectType> getIMGeoPlusObjectTypes() {
        return this.getAllObjectTypes().filter(BGTObjectType::isIMGeoPlusType);
    }

    @Override
    public BGTObjectType getObjectTypeByName(String name) {
        return (BGTObjectType)super.getObjectTypeByName(name);
    }

    public static String fixUUID(String uuidParam) {
        String uuid = uuidParam.replaceAll("-", "").toLowerCase();
        if (uuid.length() == 33 && uuid.charAt(0) == 'b') {
            return uuid.substring(1);
        }
        if (uuid.length() != 32) {
            throw new IllegalArgumentException("Invalid UUID: " + uuidParam);
        }
        return uuid;
    }

    static {
        bgtObjectTypes = new HashSet<String>(Arrays.asList("TrafficArea", "AuxiliaryTrafficArea", "Railway", "OnbegroeidTerreindeel", "PlantCover", "Waterdeel", "OndersteunendWaterdeel", "BuildingPart", "nummeraanduidingreeks", "OverigBouwwerk", "BridgeConstructionElement", "TunnelPart", "Kunstwerkdeel", "Scheiding", "FunctioneelGebied", "OpenbareRuimteLabel", "Plaatsbepalingspunt"));
        bgtBaseAttributes = Arrays.asList(new AttributeColumnMapping("gmlId", "char(32)", true, true), new AttributeColumnMapping("identificatie"), new SimpleDateFormatAttributeColumnMapping("LV-publicatiedatum", "timestamp", "yyyy-MM-dd'T'HH:mm:ss"), new SimpleDateFormatAttributeColumnMapping("creationDate", "date", "yyyy-MM-dd"), new SimpleDateFormatAttributeColumnMapping("tijdstipRegistratie", "timestamp", "yyyy-MM-dd'T'HH:mm:ss"), new SimpleDateFormatAttributeColumnMapping(EIND_REGISTRATIE, "timestamp", false, "yyyy-MM-dd'T'HH:mm:ss"), new SimpleDateFormatAttributeColumnMapping("terminationDate", "date", false, "yyyy-MM-dd"), new AttributeColumnMapping("bronhouder"), new BooleanAttributeColumnMapping("inOnderzoek"), new IntegerAttributeColumnMapping("relatieveHoogteligging"), new AttributeColumnMapping("bgt-status"), new AttributeColumnMapping("plus-status"));
    }
}

