/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.schema;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import nl.b3p.brmo.schema.Schema;
import nl.b3p.brmo.schema.mapping.ArrayAttributeMapping;
import nl.b3p.brmo.schema.mapping.AttributeColumnMapping;
import nl.b3p.brmo.schema.mapping.GeometryAttributeColumnMapping;
import nl.b3p.brmo.schema.mapping.OneToManyColumnMapping;

public class ObjectType {
    private final String name;
    private final Schema schema;
    private List<AttributeColumnMapping> attributes;
    private final List<AttributeColumnMapping> primaryKeys;
    private final List<AttributeColumnMapping> directNonDefaultInsertAttributes;
    private final List<GeometryAttributeColumnMapping> geometryAttributes;
    private List<ObjectType> oneToManyAttributeObjectTypes;
    private List<ArrayAttributeMapping> arrayAttributes;
    private List<String> extraDataDefinitionSQL = new ArrayList<String>();

    protected ObjectType(Schema schema, String name, List<AttributeColumnMapping> attributes) {
        this.schema = schema;
        this.name = name;
        this.attributes = attributes;
        this.primaryKeys = attributes.stream().filter(AttributeColumnMapping::isPrimaryKey).collect(Collectors.toList());
        this.directNonDefaultInsertAttributes = attributes.stream().filter(AttributeColumnMapping::isDirectNonDefaultAttribute).collect(Collectors.toList());
        this.geometryAttributes = attributes.stream().filter(attributeColumnMapping -> attributeColumnMapping instanceof GeometryAttributeColumnMapping).map(attributeColumnMapping -> (GeometryAttributeColumnMapping)attributeColumnMapping).collect(Collectors.toList());
    }

    public ObjectType addExtraDataDefinitionSQL(List<String> extraDataDefinitionSQL) {
        this.extraDataDefinitionSQL.addAll(extraDataDefinitionSQL);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public List<AttributeColumnMapping> getAllAttributes() {
        return this.attributes;
    }

    public List<AttributeColumnMapping> getPrimaryKeys() {
        return this.primaryKeys;
    }

    public AttributeColumnMapping getAttributeByName(String name) {
        return this.attributes.stream().filter(a -> a.getName().equals(name)).findFirst().orElse(null);
    }

    public List<AttributeColumnMapping> getDirectAttributes() {
        return this.attributes.stream().filter(AttributeColumnMapping::isDirectAttribute).collect(Collectors.toList());
    }

    public List<AttributeColumnMapping> getDirectNonDefaultInsertAttributes() {
        return this.directNonDefaultInsertAttributes;
    }

    public boolean hasOnlyDirectAttributes() {
        return this.directNonDefaultInsertAttributes.size() == this.attributes.size();
    }

    public List<ObjectType> getOneToManyAttributeObjectTypes() {
        if (this.oneToManyAttributeObjectTypes == null) {
            this.oneToManyAttributeObjectTypes = this.attributes.stream().filter(attributeColumnMapping -> attributeColumnMapping instanceof OneToManyColumnMapping).map(attributeColumnMapping -> this.schema.getObjectTypes().get(attributeColumnMapping.getName())).collect(Collectors.toList());
        }
        return this.oneToManyAttributeObjectTypes;
    }

    public List<ArrayAttributeMapping> getArrayAttributes() {
        if (this.arrayAttributes == null) {
            this.arrayAttributes = this.attributes.stream().filter(attribute -> attribute instanceof ArrayAttributeMapping).map(attribute -> (ArrayAttributeMapping)attribute).collect(Collectors.toList());
        }
        return this.arrayAttributes;
    }

    public List<GeometryAttributeColumnMapping> getGeometryAttributes() {
        return this.geometryAttributes;
    }

    public List<String> getExtraDataDefinitionSQL() {
        return this.extraDataDefinitionSQL;
    }
}

