/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import org.apache.commons.codec.binary.Hex;

public class CountingSeekableByteChannel
implements SeekableByteChannel {
    private final SeekableByteChannel channel;
    private int nonConsecutiveIops = 0;
    private boolean seeked = false;
    private long bytesRead = 0L;
    private long bytesWritten = 0L;
    private boolean loggingEnabled = false;

    public CountingSeekableByteChannel(SeekableByteChannel channel) {
        this.channel = channel;
    }

    public int getNonConsecutiveIops() {
        return this.nonConsecutiveIops;
    }

    public long getBytesRead() {
        return this.bytesRead;
    }

    public long getBytesWritten() {
        return this.bytesWritten;
    }

    public boolean isLoggingEnabled() {
        return this.loggingEnabled;
    }

    public void setLoggingEnabled(boolean loggingEnabled) {
        this.loggingEnabled = loggingEnabled;
    }

    public CountingSeekableByteChannel withLogging(boolean loggingEnabled) {
        this.loggingEnabled = loggingEnabled;
        return this;
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        if (this.seeked) {
            this.seeked = false;
            ++this.nonConsecutiveIops;
            if (this.loggingEnabled) {
                System.out.printf("new position %15d: read into buffer %s", this.channel.position(), byteBuffer);
            }
        } else if (this.loggingEnabled) {
            System.out.printf("consecutive  %15d: read into buffer %s", this.channel.position(), byteBuffer);
        }
        int startOffset = byteBuffer.arrayOffset();
        int read = this.channel.read(byteBuffer);
        if (this.loggingEnabled) {
            System.out.printf(" read %s, contents: %s\n", read, new String(Hex.encodeHex((byte[])byteBuffer.array(), (int)startOffset, (int)read, (boolean)true)));
        }
        this.bytesRead += (long)read;
        return read;
    }

    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        int written = this.channel.write(byteBuffer);
        if (written > 0) {
            this.bytesWritten += (long)written;
            if (this.seeked) {
                this.seeked = false;
                ++this.nonConsecutiveIops;
            }
        }
        return written;
    }

    @Override
    public long position() throws IOException {
        return this.channel.position();
    }

    @Override
    public SeekableByteChannel position(long newPosition) throws IOException {
        if (this.channel.position() != newPosition) {
            this.channel.position(newPosition);
            this.seeked = true;
        }
        return this;
    }

    @Override
    public long size() throws IOException {
        return this.channel.size();
    }

    @Override
    public SeekableByteChannel truncate(long newSize) throws IOException {
        return this.channel.truncate(newSize);
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public void close() throws IOException {
        if (this.channel.isOpen()) {
            this.channel.close();
            if (this.loggingEnabled) {
                System.out.printf("Total non-consecutive iops: %d, bytes read: %d, written: %d\n", this.nonConsecutiveIops, this.bytesRead, this.bytesWritten);
            }
        }
    }
}

