/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.util.http.wrapper;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import nl.b3p.brmo.util.http.HttpClientWrapper;
import nl.b3p.brmo.util.http.HttpResponseWrapper;

public class Java11HttpClientWrapper
implements HttpClientWrapper<HttpRequest.Builder, HttpResponse<InputStream>> {
    private final HttpClient httpClient;

    public Java11HttpClientWrapper() {
        this(HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL));
    }

    public Java11HttpClientWrapper(HttpClient.Builder builder) {
        if (System.getProperty("httpclientwrapper.java11.http1_1") != null) {
            builder.version(HttpClient.Version.HTTP_1_1);
        }
        this.httpClient = builder.build();
    }

    @Override
    public HttpResponseWrapper request(URI uri, String ... requestHeaders) throws IOException, InterruptedException {
        HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().uri(uri);
        if (requestHeaders.length > 0) {
            requestBuilder.headers(requestHeaders);
        }
        this.beforeRequest(requestBuilder);
        HttpRequest request = requestBuilder.build();
        HttpResponse<InputStream> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofInputStream());
        return this.wrapResponse(response);
    }

    @Override
    public void beforeRequest(HttpRequest.Builder requestBuilder) {
    }

    @Override
    public HttpResponseWrapper wrapResponse(final HttpResponse<InputStream> response) {
        return new HttpResponseWrapper(){

            @Override
            public int getStatusCode() {
                return response.statusCode();
            }

            @Override
            public String getHeader(String header) {
                return response.headers().firstValue(header).orElse(null);
            }

            @Override
            public InputStream getResponseBody() {
                return (InputStream)response.body();
            }
        };
    }
}

