/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.bgt.loader;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import nl.b3p.brmo.bgt.loader.ProgressReporter;
import nl.b3p.brmo.bgt.loader.Utils;
import nl.b3p.brmo.bgt.loader.cli.ConsoleProgressReporter;
import nl.b3p.brmo.bgt.schema.BGTObjectTableWriter;
import nl.b3p.brmo.util.ResumingInputStream;
import nl.b3p.brmo.util.http.HttpResponseWrapper;
import nl.b3p.brmo.util.http.HttpStartRangeInputStreamProvider;
import nl.b3p.brmo.util.http.wrapper.Java11HttpClientWrapper;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResumingBGTDownloadInputStream
extends ResumingInputStream {
    private static final Log log = LogFactory.getLog(ResumingBGTDownloadInputStream.class);

    public ResumingBGTDownloadInputStream(URI uri, BGTObjectTableWriter writer) {
        this(uri, writer, false);
    }

    public ResumingBGTDownloadInputStream(URI uri, final BGTObjectTableWriter writer, final boolean logRetries) {
        super(new HttpStartRangeInputStreamProvider(uri, new Java11HttpClientWrapper(){

            @Override
            public void beforeRequest(HttpRequest.Builder requestBuilder) {
                requestBuilder.headers("User-Agent", Utils.getUserAgent());
            }

            @Override
            public HttpResponseWrapper wrapResponse(HttpResponse<InputStream> response) {
                String contentLength;
                HttpResponseWrapper wrapper = super.wrapResponse(response);
                if (wrapper.getHeader("Content-Range") == null && (contentLength = wrapper.getHeader("Content-Range")) != null) {
                    ((ProgressReporter)writer.getProgressUpdater()).setTotalBytes(Long.parseLong(contentLength));
                }
                return wrapper;
            }
        }){

            @Override
            public InputStream get(long position, int totalRetries, Exception causeForRetry) throws IOException {
                if (causeForRetry != null && logRetries) {
                    String msg = Utils.getMessageFormattedString("download.retry", totalRetries, position, ExceptionUtils.getRootCause((Throwable)causeForRetry).getMessage());
                    if (writer.getProgressUpdater() instanceof ConsoleProgressReporter) {
                        System.out.println("\r" + msg);
                    } else {
                        log.warn((Object)msg);
                        log.trace((Object)causeForRetry);
                    }
                }
                return super.get(position, totalRetries, causeForRetry);
            }
        });
    }
}

