/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.bgt.loader.cli;

import java.net.URI;
import java.sql.SQLException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import nl.b3p.brmo.bgt.download.api.CustomDownloadProgress;
import nl.b3p.brmo.bgt.download.api.DeltaApi;
import nl.b3p.brmo.bgt.download.api.DownloadApiUtils;
import nl.b3p.brmo.bgt.download.client.ApiClient;
import nl.b3p.brmo.bgt.download.client.ApiException;
import nl.b3p.brmo.bgt.download.model.Delta;
import nl.b3p.brmo.bgt.download.model.GetDeltasResponse;
import nl.b3p.brmo.bgt.loader.BGTDatabase;
import nl.b3p.brmo.bgt.loader.ProgressReporter;
import nl.b3p.brmo.bgt.loader.Utils;
import nl.b3p.brmo.bgt.loader.cli.BGTLoaderMain;
import nl.b3p.brmo.bgt.loader.cli.CLIOptions;
import nl.b3p.brmo.bgt.loader.cli.ConsoleProgressReporter;
import nl.b3p.brmo.bgt.loader.cli.CustomDownloadProgressReporter;
import nl.b3p.brmo.bgt.loader.cli.DatabaseOptions;
import nl.b3p.brmo.bgt.loader.cli.ExtractSelectionOptions;
import nl.b3p.brmo.bgt.loader.cli.LoadOptions;
import nl.b3p.brmo.bgt.schema.BGTObjectTableWriter;
import nl.b3p.brmo.bgt.schema.BGTSchemaMapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import picocli.CommandLine;

@CommandLine.Command(name="download", mixinStandardHelpOptions=true)
public class DownloadCommand {
    private static final Log log = LogFactory.getLog(DownloadCommand.class);
    private static final String PREDEFINED_FULL_DELTA_URI = "https://api.pdok.nl/lv/bgt/download/v1_0/delta/predefined/bgt-citygml-nl-delta.zip";
    private BGTDatabase bgtDatabase = null;

    public static ApiClient getApiClient(URI baseUri) {
        ApiClient client = new ApiClient();
        if (baseUri != null) {
            client.updateBaseUri(baseUri.toString());
        }
        client.setRequestInterceptor(builder -> builder.headers("User-Agent", Utils.getUserAgent()));
        return client;
    }

    private BGTObjectTableWriter createWriter(BGTDatabase db, DatabaseOptions dbOptions, LoadOptions loadOptions, CLIOptions cliOptions) throws SQLException {
        BGTObjectTableWriter writer = db.createObjectTableWriter(loadOptions, dbOptions);
        ProgressReporter progressReporter = cliOptions.isConsoleProgressEnabled() ? new ConsoleProgressReporter() : new ProgressReporter();
        writer.setProgressUpdater(progressReporter);
        return writer;
    }

    @CommandLine.Command(name="initial", sortOptions=false)
    public int initial(@CommandLine.Mixin DatabaseOptions dbOptions, @CommandLine.Mixin LoadOptions loadOptions, @CommandLine.Mixin ExtractSelectionOptions extractSelectionOptions, @CommandLine.Option(names={"--no-geo-filter"}) boolean noGeoFilter, @CommandLine.Option(names={"--download-service"}, hidden=true) URI downloadServiceURI, @CommandLine.Mixin CLIOptions cliOptions, @CommandLine.Option(names={"-h", "--help"}, usageHelp=true) boolean showHelp) throws Exception {
        if (extractSelectionOptions.getGeoFilterWkt() == null && !noGeoFilter) {
            log.error((Object)Utils.getBundleString("download.no_geo_filter"));
            return 2;
        }
        log.info((Object)Utils.getUserAgent());
        try (BGTDatabase db = this.getBGTdatabase(dbOptions);){
            URI uri;
            if (loadOptions.createSchema) {
                db.createMetadataTable(loadOptions);
            } else {
                log.info((Object)Utils.getBundleString("download.connect_db"));
            }
            db.setMetadataValue(BGTSchemaMapper.Metadata.LOADER_VERSION, Utils.getLoaderVersion());
            db.setMetadataValue(BGTSchemaMapper.Metadata.BRMOVERSIE, Utils.getBrmoVersion());
            db.setFeatureTypesEnumMetadata(extractSelectionOptions.getFeatureTypesList());
            db.setMetadataValue(BGTSchemaMapper.Metadata.INCLUDE_HISTORY, "" + loadOptions.includeHistory);
            db.setMetadataValue(BGTSchemaMapper.Metadata.LINEARIZE_CURVES, "" + loadOptions.linearizeCurves);
            db.setMetadataValue(BGTSchemaMapper.Metadata.TABLE_PREFIX, loadOptions.tablePrefix);
            Instant start = null;
            if (noGeoFilter) {
                uri = new URI(PREDEFINED_FULL_DELTA_URI);
            } else {
                db.close();
                start = Instant.now();
                uri = DownloadCommand.getCustomDownloadURI(downloadServiceURI, extractSelectionOptions, new CustomDownloadProgressReporter(cliOptions.isConsoleProgressEnabled()));
            }
            BGTObjectTableWriter writer = this.createWriter(db, dbOptions, loadOptions, cliOptions);
            DownloadCommand.loadZipFromURI(uri, db, writer, extractSelectionOptions, loadOptions, noGeoFilter, start);
            db.setMetadataValue(BGTSchemaMapper.Metadata.DELTA_TIME_TO, null);
            db.setMetadataValue(BGTSchemaMapper.Metadata.GEOM_FILTER, extractSelectionOptions.getGeoFilterWkt());
            db.getConnection().commit();
            int n = 0;
            return n;
        }
    }

    public void setBGTDatabase(BGTDatabase bgtDatabase) {
        this.bgtDatabase = bgtDatabase;
    }

    private BGTDatabase getBGTdatabase(DatabaseOptions dbOptions) throws ClassNotFoundException {
        if (null == this.bgtDatabase) {
            return new BGTDatabase(dbOptions);
        }
        return this.bgtDatabase;
    }

    private static URI getCustomDownloadURI(URI downloadServiceURI, ExtractSelectionOptions extractSelectionOptions, Consumer<CustomDownloadProgress> progressConsumer) throws ApiException, InterruptedException {
        try {
            log.info((Object)Utils.getBundleString("download.create"));
            ApiClient client = DownloadCommand.getApiClient(downloadServiceURI);
            return DownloadApiUtils.getCustomDownloadURL(client, null, extractSelectionOptions, progressConsumer);
        }
        catch (ApiException apiException) {
            DownloadCommand.printApiException(apiException);
            throw apiException;
        }
    }

    @CommandLine.Command(name="update", sortOptions=false)
    public int update(@CommandLine.Mixin DatabaseOptions dbOptions, @CommandLine.Mixin CLIOptions cliOptions, @CommandLine.Option(names={"--download-service"}, hidden=true) URI downloadServiceURI, @CommandLine.Option(names={"--no-http-zip-random-access"}, negatable=true, hidden=true) boolean noHttpZipRandomAccess, @CommandLine.Option(names={"-h", "--help"}, usageHelp=true) boolean showHelp) throws Exception {
        log.info((Object)Utils.getUserAgent());
        ApiClient client = DownloadCommand.getApiClient(downloadServiceURI);
        log.info((Object)Utils.getBundleString("download.connect_db"));
        try (BGTDatabase db = this.getBGTdatabase(dbOptions);){
            List<Delta> deltas;
            Instant start;
            LoadOptions loadOptions;
            ExtractSelectionOptions extractSelectionOptions;
            block19: {
                String deltaId = db.getMetadata(BGTSchemaMapper.Metadata.DELTA_ID);
                OffsetDateTime deltaIdTimeTo = null;
                String s = db.getMetadata(BGTSchemaMapper.Metadata.DELTA_TIME_TO);
                if (s != null && s.length() > 0) {
                    deltaIdTimeTo = OffsetDateTime.parse(s);
                }
                if (deltaId == null) {
                    log.error((Object)Utils.getBundleString("download.no_delta_id"));
                    int n = 1;
                    return n;
                }
                extractSelectionOptions = new ExtractSelectionOptions();
                extractSelectionOptions.setGeoFilterWkt(db.getMetadata(BGTSchemaMapper.Metadata.GEOM_FILTER));
                if (extractSelectionOptions.getGeoFilterWkt() != null && extractSelectionOptions.getGeoFilterWkt().length() == 0) {
                    extractSelectionOptions.setGeoFilterWkt(null);
                }
                extractSelectionOptions.setFeatureTypes(Arrays.asList(db.getMetadata(BGTSchemaMapper.Metadata.FEATURE_TYPES).split(",")));
                loadOptions = new LoadOptions();
                loadOptions.setHttpZipRandomAccess(!noHttpZipRandomAccess);
                loadOptions.includeHistory = Boolean.parseBoolean(db.getMetadata(BGTSchemaMapper.Metadata.INCLUDE_HISTORY));
                loadOptions.linearizeCurves = Boolean.parseBoolean(db.getMetadata(BGTSchemaMapper.Metadata.LINEARIZE_CURVES));
                loadOptions.tablePrefix = Objects.requireNonNullElse(db.getMetadata(BGTSchemaMapper.Metadata.TABLE_PREFIX), "");
                log.info((Object)(Utils.getMessageFormattedString("download.current_delta_id", deltaId) + ", " + (deltaIdTimeTo != null ? Utils.getMessageFormattedString("download.current_delta_time", DateTimeFormatter.ISO_INSTANT.format(deltaIdTimeTo)) : Utils.getBundleString("download.current_delta_time_unknown"))));
                try {
                    Delta d2;
                    int i;
                    start = Instant.now();
                    log.info((Object)Utils.getBundleString("download.loading_deltas"));
                    GetDeltasResponse response = new DeltaApi(client).getDeltas(null, 1, 100);
                    if (response.getLinks() != null && !response.getLinks().isEmpty()) {
                        throw new IllegalStateException("Did not expect links in GetDeltas response");
                    }
                    for (i = 0; i < response.getDeltas().size() && !deltaId.equals((d2 = response.getDeltas().get(i)).getId()); ++i) {
                    }
                    if (i == response.getDeltas().size()) {
                        log.error((Object)Utils.getBundleString("download.current_delta_not_found"));
                        int d2 = 1;
                        return d2;
                    }
                    deltas = response.getDeltas().subList(i + 1, response.getDeltas().size());
                    if (!deltas.isEmpty()) break block19;
                }
                catch (ApiException apiException) {
                    DownloadCommand.printApiException(apiException);
                    throw apiException;
                }
                log.info((Object)Utils.getBundleString("download.uptodate"));
                int n = 0;
                return n;
            }
            Delta latestDelta = deltas.get(deltas.size() - 1);
            log.info((Object)Utils.getMessageFormattedString("download.updates_available", deltas.size(), latestDelta.getId(), latestDelta.getTimeWindow().getTo()));
            BGTObjectTableWriter writer = this.createWriter(db, dbOptions, loadOptions, cliOptions);
            int deltaCount = 1;
            for (Delta delta : deltas) {
                log.info((Object)Utils.getMessageFormattedString("download.creating_download", deltaCount++, deltas.size(), delta.getId()));
                URI uri = DownloadApiUtils.getCustomDownloadURL(client, delta, extractSelectionOptions, new CustomDownloadProgressReporter(cliOptions.isConsoleProgressEnabled()));
                DownloadCommand.loadZipFromURI(uri, db, writer, extractSelectionOptions, loadOptions, false, start);
                db.setMetadataValue(BGTSchemaMapper.Metadata.DELTA_TIME_TO, delta.getTimeWindow().getTo().toString());
                db.getConnection().commit();
            }
            db.setMetadataValue(BGTSchemaMapper.Metadata.LOADER_VERSION, Utils.getLoaderVersion());
            db.getConnection().commit();
            int n = 0;
            return n;
        }
    }

    private static void printApiException(ApiException apiException) {
        log.error((Object)String.format("API status code: %d, body: %s\n", apiException.getCode(), apiException.getResponseBody()));
    }

    private static void loadZipFromURI(URI uri, BGTDatabase db, BGTObjectTableWriter writer, ExtractSelectionOptions extractSelectionOptions, LoadOptions loadOptions, boolean showSelected, Instant start) throws Exception {
        Instant loadStart = Instant.now();
        new BGTLoaderMain().loadZipFromURI(uri, writer, extractSelectionOptions, loadOptions, showSelected);
        db.setMetadataForMutaties(writer.getProgress().getMutatieInhoud());
        log.info((Object)(Utils.getMessageFormattedString("download.complete", Utils.getBundleString("download.mutatietype." + writer.getProgress().getMutatieInhoud().getMutatieType()), writer.getProgress().getMutatieInhoud().getLeveringsId(), Utils.formatTimeSince(loadStart)) + (String)(start == null ? "" : " " + Utils.getMessageFormattedString("download.complete_total", Utils.formatTimeSince(start)))));
    }
}

