/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.bgt.schema;

import java.io.InputStream;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import nl.b3p.brmo.bgt.loader.BGTObjectStreamer;
import nl.b3p.brmo.bgt.schema.BGTObject;
import nl.b3p.brmo.bgt.schema.BGTObjectType;
import nl.b3p.brmo.schema.ObjectTableWriter;
import nl.b3p.brmo.schema.ObjectType;
import nl.b3p.brmo.schema.SchemaSQLMapper;
import nl.b3p.brmo.sql.PreparedStatementQueryBatch;
import nl.b3p.brmo.sql.QueryBatch;
import nl.b3p.brmo.sql.dialect.SQLDialect;
import org.apache.commons.io.input.CountingInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BGTObjectTableWriter
extends ObjectTableWriter {
    private static final Log log = LogFactory.getLog(BGTObjectTableWriter.class);
    private boolean currentObjectsOnly = true;

    public boolean isCurrentObjectsOnly() {
        return this.currentObjectsOnly;
    }

    public void setCurrentObjectsOnly(boolean currentObjectsOnly) {
        this.currentObjectsOnly = currentObjectsOnly;
    }

    public BGTObjectTableWriter(Connection connection, SQLDialect dialect, SchemaSQLMapper schemaSQLMapper) {
        super(connection, dialect, schemaSQLMapper);
    }

    @Override
    public BGTProgress getProgress() {
        return (BGTProgress)super.getProgress();
    }

    private void deletePreviousVersion(BGTObject object) throws Exception {
        BGTObjectType objectType = object.getObjectType();
        String idAttributeName = objectType.getPrimaryKeys().get(0).getName();
        String tableName = this.getSchemaSQLMapper().getTableNameForObjectType(objectType, this.getTablePrefix());
        Map<ObjectType, QueryBatch> deleteBatches = this.getProgress().deleteBatches;
        if (!deleteBatches.containsKey(objectType)) {
            String sql = "delete from " + tableName + " where " + this.getSchemaSQLMapper().getColumnNameForObjectType(objectType, idAttributeName) + " = ?";
            deleteBatches.put(objectType, new PreparedStatementQueryBatch(this.getConnection(), sql, this.getBatchSize()));
        }
        QueryBatch batch = deleteBatches.get(objectType);
        boolean executed = batch.addBatch(new Object[]{object.getMutatiePreviousVersionGmlId()});
        for (ObjectType oneToManyObjectType : objectType.getOneToManyAttributeObjectTypes()) {
            if (!deleteBatches.containsKey(oneToManyObjectType)) {
                String tableNameNoPrefix = this.getSchemaSQLMapper().getTableNameForObjectType(objectType, "");
                String sql = "delete from " + this.getSchemaSQLMapper().getTableNameForObjectType(oneToManyObjectType, this.getTablePrefix()) + " where " + this.getSchemaSQLMapper().getColumnNameForObjectType(oneToManyObjectType, tableNameNoPrefix + idAttributeName) + " = ?";
                deleteBatches.put(oneToManyObjectType, new PreparedStatementQueryBatch(this.getConnection(), sql, this.getBatchSize()));
            }
            QueryBatch deleteBatch = deleteBatches.get(oneToManyObjectType);
            executed |= deleteBatch.addBatch(new Object[]{object.getMutatiePreviousVersionGmlId()});
        }
        if (executed) {
            this.updateProgress();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(InputStream bgtXml) throws Exception {
        BGTProgress progress = new BGTProgress();
        super.start(progress);
        this.updateProgress(ObjectTableWriter.Stage.PARSE_INPUT);
        try (CountingInputStream counter = new CountingInputStream(bgtXml);){
            progress.counter = counter;
            BGTObjectStreamer streamer = new BGTObjectStreamer((InputStream)counter);
            progress.mutatieInhoud = streamer.getMutatieInhoud();
            this.updateProgress(ObjectTableWriter.Stage.LOAD_OBJECTS);
            progress.setInitialLoad(progress.mutatieInhoud == null || "initial".equals(progress.getMutatieInhoud().getMutatieType()));
            for (BGTObject object : streamer) {
                boolean skipHistoricObject;
                this.prepareDatabaseForObject(object);
                boolean bl = skipHistoricObject = object.getAttributes().get("eindRegistratie") != null && this.currentObjectsOnly;
                if (object.getMutatieStatus() == BGTObject.MutatieStatus.WAS_WORDT) {
                    this.deletePreviousVersion(object);
                    if (skipHistoricObject) {
                        ++progress.objectRemovedCount;
                    } else {
                        ++progress.objectUpdatedCount;
                    }
                } else if (object.getMutatieStatus() == BGTObject.MutatieStatus.WORDT) {
                    if (skipHistoricObject) {
                        ++progress.historicObjectsCount;
                    } else {
                        progress.incrementObjectCount();
                    }
                }
                if (skipHistoricObject) continue;
                this.addObjectToBatch(object);
                if (this.getObjectLimit() == null || progress.getObjectCount() != (long)this.getObjectLimit().intValue()) continue;
                break;
            }
            super.endOfObjects();
            for (QueryBatch batch : progress.deleteBatches.values()) {
                batch.executeBatch();
            }
            super.complete();
        }
        finally {
            super.closeBatches();
            progress.deleteBatches.values().stream().forEach(QueryBatch::closeQuietly);
        }
    }

    public class BGTProgress
    extends ObjectTableWriter.Progress {
        private CountingInputStream counter;
        private Map<ObjectType, QueryBatch> deleteBatches;
        private long objectUpdatedCount;
        private long objectRemovedCount;
        private long historicObjectsCount;
        private BGTObjectStreamer.MutatieInhoud mutatieInhoud;

        public BGTProgress() {
            super(BGTObjectTableWriter.this);
            this.deleteBatches = new HashMap<ObjectType, QueryBatch>();
            this.objectUpdatedCount = 0L;
            this.objectRemovedCount = 0L;
            this.historicObjectsCount = 0L;
        }

        public long getBytesRead() {
            return this.counter.getByteCount();
        }

        public long getObjectUpdatedCount() {
            return this.objectUpdatedCount;
        }

        public long getObjectRemovedCount() {
            return this.objectRemovedCount;
        }

        public long getHistoricObjectsCount() {
            return this.historicObjectsCount;
        }

        public BGTObjectStreamer.MutatieInhoud getMutatieInhoud() {
            return this.mutatieInhoud;
        }

        @Override
        public BGTObjectTableWriter getWriter() {
            return BGTObjectTableWriter.this;
        }
    }
}

