/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.schema;

import java.util.Map;
import java.util.TreeSet;
import nl.b3p.brmo.schema.ObjectType;
import org.geotools.geometry.jts.WKTWriter2;
import org.locationtech.jts.geom.Geometry;

public class SchemaObjectInstance {
    private final ObjectType objectType;
    private final Map<String, Object> attributes;
    private final WKTWriter2 wktWriter2 = new WKTWriter2();

    public SchemaObjectInstance(ObjectType objectType, Map<String, Object> attributes) {
        this.objectType = objectType;
        this.attributes = attributes;
    }

    public ObjectType getObjectType() {
        return this.objectType;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public String toString() {
        StringBuilder s = new StringBuilder(this.objectType.getName());
        s.append("{");
        TreeSet<String> attributeNames = new TreeSet<String>(this.attributes.keySet());
        boolean first = true;
        for (String name : attributeNames) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            s.append(name);
            s.append("=");
            Object value = this.attributes.get(name);
            if (value instanceof Geometry) {
                value = this.wktWriter2.write((Geometry)value);
            }
            s.append(value);
        }
        s.append("}");
        return s.toString();
    }
}

