/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.sql;

import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.SQLException;
import nl.b3p.brmo.sql.PostgresCopyEscapeUtils;
import nl.b3p.brmo.sql.QueryBatch;
import nl.b3p.brmo.sql.dialect.PostGISDialect;
import nl.b3p.brmo.sql.dialect.SQLDialect;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.text.StringEscapeUtils;
import org.locationtech.jts.geom.Geometry;
import org.postgresql.PGConnection;
import org.postgresql.copy.CopyIn;

public class PostGISCopyInsertBatch
implements QueryBatch {
    private static final Log LOG = LogFactory.getLog(PostGISCopyInsertBatch.class);
    protected Connection connection;
    protected String sql;
    protected PostGISDialect dialect;
    protected int batchSize;
    protected boolean linearizeCurves;
    protected int count = 0;
    protected StringEscapeUtils.Builder copyData = PostgresCopyEscapeUtils.builder();
    protected CopyIn copyIn = null;
    protected CopyIn lastCopyIn = null;
    protected boolean buffer;

    public PostGISCopyInsertBatch(Connection connection, String sql, int batchSize, SQLDialect dialect, boolean buffer, boolean linearizeCurves) {
        if (!(dialect instanceof PostGISDialect)) {
            throw new IllegalArgumentException();
        }
        this.connection = connection;
        this.sql = sql;
        this.dialect = (PostGISDialect)dialect;
        this.batchSize = batchSize;
        this.buffer = buffer;
        this.linearizeCurves = linearizeCurves;
    }

    protected void createCopyIn() throws SQLException {
        PGConnection pgConnection = this.connection.unwrap(PGConnection.class);
        this.copyIn = pgConnection.getCopyAPI().copyIn(this.sql);
    }

    protected void writeToCopy() throws SQLException {
        if (this.copyIn == null) {
            this.createCopyIn();
        }
        byte[] bytes = this.copyData.toString().getBytes(StandardCharsets.UTF_8);
        this.copyIn.writeToCopy(bytes, 0, bytes.length);
        this.copyData = PostgresCopyEscapeUtils.builder();
    }

    @Override
    public boolean addBatch(Object[] params) throws Exception {
        for (int i = 0; i < params.length; ++i) {
            Object param;
            if (i != 0) {
                this.copyData.append("\t");
            }
            if ((param = params[i]) == null) {
                this.copyData.append("\\N");
                continue;
            }
            if (param instanceof Geometry) {
                Geometry geometry = (Geometry)param;
                this.copyData.append(this.dialect.getEWkt(geometry, this.linearizeCurves));
                continue;
            }
            if (param instanceof Boolean) {
                this.copyData.append((Boolean)param != false ? "t" : "f");
                continue;
            }
            this.copyData.escape(param.toString());
        }
        this.copyData.append("\n");
        if (!this.buffer) {
            this.writeToCopy();
        }
        ++this.count;
        if (this.count == this.batchSize) {
            this.executeBatch();
            return true;
        }
        return false;
    }

    @Override
    public void executeBatch() throws Exception {
        if (this.count > 0) {
            if (this.buffer) {
                if (LOG.isDebugEnabled()) {
                    int bytes = this.copyData.toString().getBytes(StandardCharsets.UTF_8).length;
                    LOG.debug((Object)String.format("execute buffered copy batch, %d bytes, %d rows, sql: %s", bytes, this.count, this.sql));
                }
                this.writeToCopy();
            } else {
                LOG.debug((Object)String.format("execute copy batch, %d rows, sql: %s", this.count, this.sql));
            }
            this.copyIn.endCopy();
            this.lastCopyIn = this.copyIn;
            this.copyIn = null;
            this.count = 0;
        }
    }

    @Override
    public void close() {
    }
}

