/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.sql;

import java.sql.Connection;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import nl.b3p.brmo.sql.QueryBatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PreparedStatementQueryBatch
implements QueryBatch {
    private static final Log LOG = LogFactory.getLog(PreparedStatementQueryBatch.class);
    protected final Connection c;
    private final String sql;
    private final int batchSize;
    private int count = 0;
    protected PreparedStatement ps;
    private int[] parameterTypes;

    public PreparedStatementQueryBatch(Connection c, String sql, int batchSize) throws SQLException {
        this.c = c;
        this.sql = sql;
        this.batchSize = batchSize;
        this.initializePreparedStatement();
    }

    private void initializePreparedStatement() throws SQLException {
        this.ps = this.c.prepareStatement(this.sql);
        this.parameterTypes = null;
        try {
            ParameterMetaData pmd = this.ps.getParameterMetaData();
            if (pmd != null) {
                this.parameterTypes = new int[pmd.getParameterCount()];
                for (int i = 0; i < pmd.getParameterCount(); ++i) {
                    this.parameterTypes[i] = pmd.getParameterType(i + 1);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean addBatch(Object[] params) throws Exception {
        for (int i = 0; i < params.length; ++i) {
            int parameterIndex = i + 1;
            try {
                int pmdType = this.parameterTypes != null ? this.parameterTypes[i] : 12;
                this.setPreparedStatementParameter(parameterIndex, pmdType, params[i]);
                continue;
            }
            catch (Exception e) {
                throw new Exception(String.format("Exception setting parameter %s to value %s for insert SQL \"%s\"", i, params[i], this.sql), e);
            }
        }
        this.ps.addBatch();
        ++this.count;
        if (this.count == this.batchSize) {
            this.executeBatch();
            return true;
        }
        return false;
    }

    @Override
    public void executeBatch() throws Exception {
        if (this.count > 0) {
            LOG.debug((Object)String.format("execute batch, size %d, sql: %s", this.count, this.sql));
            this.ps.executeBatch();
            this.count = 0;
        }
    }

    @Override
    public void close() throws SQLException {
        this.ps.close();
    }

    protected void setPreparedStatementParameter(int oneBasedParameterIndex, int parameterMetadataType, Object parameter) throws SQLException {
        if (parameter != null) {
            this.ps.setObject(oneBasedParameterIndex, parameter);
        } else {
            this.ps.setNull(oneBasedParameterIndex, parameterMetadataType);
        }
    }
}

