/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.util.http.wrapper;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URLConnection;
import nl.b3p.brmo.util.http.HttpClientWrapper;
import nl.b3p.brmo.util.http.HttpResponseWrapper;

public class URLConnectionHttpClientWrapper
implements HttpClientWrapper<HttpURLConnection, HttpURLConnection> {
    @Override
    public HttpResponseWrapper request(URI uri, String ... requestHeaders) throws IOException {
        URLConnection connection = uri.toURL().openConnection();
        if (!(connection instanceof HttpURLConnection)) {
            throw new IllegalArgumentException("Expected HttpURLConnection instance for URI " + uri);
        }
        HttpURLConnection httpURLConnection = (HttpURLConnection)connection;
        httpURLConnection.setInstanceFollowRedirects(true);
        if (requestHeaders.length % 2 != 0) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < requestHeaders.length; i += 2) {
            httpURLConnection.setRequestProperty(requestHeaders[i], requestHeaders[i + 1]);
        }
        this.beforeRequest(httpURLConnection);
        httpURLConnection.connect();
        return this.wrapResponse(httpURLConnection);
    }

    @Override
    public void beforeRequest(HttpURLConnection httpURLConnection) {
    }

    @Override
    public HttpResponseWrapper wrapResponse(final HttpURLConnection httpURLConnection) {
        return new HttpResponseWrapper(){

            @Override
            public int getStatusCode() throws IOException {
                return httpURLConnection.getResponseCode();
            }

            @Override
            public String getHeader(String header) {
                return httpURLConnection.getHeaderField(header);
            }

            @Override
            public InputStream getResponseBody() throws IOException {
                return httpURLConnection.getInputStream();
            }
        };
    }
}

