/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.sql.dialect;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.locationtech.jts.geom.Geometry;

public interface SQLDialect {
    public String getDriverClass() throws ClassNotFoundException;

    default public void loadDriver() throws ClassNotFoundException {
        Class.forName(this.getDriverClass());
    }

    default public String getType(String type) {
        return type;
    }

    default public boolean supportsDropTableIfExists() {
        return true;
    }

    default public Object getGeometryParameter(Connection c, Geometry geometry) throws SQLException {
        return this.getGeometryParameter(c, geometry, false);
    }

    public Object getGeometryParameter(Connection var1, Geometry var2, boolean var3) throws SQLException;

    default public void setGeometryParameter(Connection c, PreparedStatement ps, int parameterIndex, int pmdType, Geometry geometry, boolean linearizeCurves) throws SQLException {
        if (geometry == null) {
            ps.setNull(parameterIndex, pmdType);
        } else {
            ps.setObject(parameterIndex, this.getGeometryParameter(c, geometry, linearizeCurves));
        }
    }

    default public String getCreateGeometryMetadataSQL(String tableName, String geometryColumn, String type) {
        return "";
    }

    default public String getCreateGeometryIndexSQL(String tableName, String geometryColumn, String type) {
        return "";
    }

    public int getDefaultOptimalBatchSize();

    default public boolean tableExists(Connection c, String name) throws SQLException {
        try (ResultSet tables = c.getMetaData().getTables(null, null, null, new String[]{"TABLE"});){
            while (tables.next()) {
                if (!tables.getString("TABLE_NAME").equalsIgnoreCase(name)) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }
}

