/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.bgt.loader;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import nl.b3p.brmo.bgt.schema.BGTObject;
import nl.b3p.brmo.bgt.schema.BGTObjectType;
import nl.b3p.brmo.bgt.schema.BGTSchema;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.staxmate.SMInputFactory;
import org.codehaus.staxmate.in.SMEvent;
import org.codehaus.staxmate.in.SMInputCursor;
import org.geotools.api.referencing.FactoryException;
import org.geotools.gml.stream.XmlStreamGeometryReader;
import org.locationtech.jts.geom.Geometry;

public class BGTObjectStreamer
implements Iterable<BGTObject> {
    private static final Log log = LogFactory.getLog(BGTObjectStreamer.class);
    private static final String NS_IMGEO = "http://www.geostandaarden.nl/imgeo/2.1";
    private static final String NS_CITYGML = "http://www.opengis.net/citygml/2.0";
    private static final String NS_GML = "http://www.opengis.net/gml";
    private static final String NS_MUTATIELEVERING = "http://www.kadaster.nl/schemas/mutatielevering-generiek/2.0";
    private static final String NS_MUTATIELEVERING_BGT = "http://www.kadaster.nl/schemas/mutatielevering-bgt/1.0";
    private static final QName CITYGML_CITY_OBJECT_MEMBER = new QName("http://www.opengis.net/citygml/2.0", "cityObjectMember");
    private static final QName CITYGML_CITY_MODEL = new QName("http://www.opengis.net/citygml/2.0", "CityModel");
    private static final QName MUTATIE_BERICHT = new QName("http://www.kadaster.nl/schemas/mutatielevering-generiek/2.0", "mutatieBericht");
    private static final QName BGT_MUTATIES = new QName("http://www.kadaster.nl/schemas/mutatielevering-bgt/1.0", "bgtMutaties");
    private static final QName BGT_OBJECT = new QName("http://www.kadaster.nl/schemas/mutatielevering-bgt/1.0", "bgtObject");
    private static final QName LOKAAL_ID = new QName("http://www.geostandaarden.nl/imgeo/2.1", "lokaalID");
    private static final int SRID = 28992;
    private final XmlStreamGeometryReader geometryReader;
    private final SMInputCursor cursor;
    private boolean isMutaties;
    private boolean hasMutatieGroep = false;
    private MutatieInhoud mutatieInhoud;
    private static final QName CAPITALIZED_NUMMERAANDUIDINGREEKS = new QName("http://www.geostandaarden.nl/imgeo/2.1", "Nummeraanduidingreeks");
    private static final QName LOWERCASE_NUMMERAANDUIDINGREEKS = new QName("http://www.geostandaarden.nl/imgeo/2.1", "nummeraanduidingreeks");
    private static final QName LABEL = new QName("http://www.geostandaarden.nl/imgeo/2.1", "Label");
    private static final QName LABELPOSITIE = new QName("http://www.geostandaarden.nl/imgeo/2.1", "Labelpositie");

    public MutatieInhoud getMutatieInhoud() {
        return this.mutatieInhoud;
    }

    public BGTObjectStreamer(File f) throws XMLStreamException {
        this.cursor = this.initCursor((SMInputCursor)this.buildSMInputFactory().rootElementCursor(f));
        this.geometryReader = this.buildGeometryReader();
    }

    public BGTObjectStreamer(InputStream in) throws XMLStreamException {
        this.cursor = this.initCursor((SMInputCursor)this.buildSMInputFactory().rootElementCursor(in));
        this.geometryReader = this.buildGeometryReader();
    }

    public BGTObjectStreamer(Reader r) throws XMLStreamException {
        this.cursor = this.initCursor((SMInputCursor)this.buildSMInputFactory().rootElementCursor(r));
        this.geometryReader = this.buildGeometryReader();
    }

    private SMInputCursor initCursor(SMInputCursor cursor) throws XMLStreamException {
        block18: {
            QName root = cursor.advance().getQName();
            if (root.equals(CITYGML_CITY_MODEL)) {
                this.isMutaties = false;
            } else if (root.equals(BGT_MUTATIES)) {
                this.isMutaties = true;
            } else {
                throw new IllegalArgumentException("XML root element moet CityModel of bgtMutaties zijn");
            }
            if (this.isMutaties) {
                cursor = cursor.childElementCursor(MUTATIE_BERICHT).advance().childElementCursor().advance();
                block10: do {
                    switch (cursor.getLocalName()) {
                        case "dataset": {
                            assert (cursor.collectDescendantText().equals("bgt"));
                            continue block10;
                        }
                        case "inhoud": {
                            this.mutatieInhoud = BGTObjectStreamer.parseInhoud(cursor);
                            break;
                        }
                        case "mutatieGroep": {
                            this.hasMutatieGroep = true;
                            break block18;
                        }
                        default: {
                            throw new IllegalStateException("Verwacht mutatieGroep element, gevonden " + cursor.getQName());
                        }
                    }
                } while (cursor.getNext() != null);
            } else {
                cursor = cursor.childElementCursor(CITYGML_CITY_OBJECT_MEMBER).advance();
            }
        }
        return cursor;
    }

    private static MutatieInhoud parseInhoud(SMInputCursor inhoudCursor) throws XMLStreamException {
        SMInputCursor cursor = inhoudCursor.childElementCursor();
        MutatieInhoud mutatieInhoud = new MutatieInhoud();
        while (cursor.getNext() != null) {
            switch (cursor.getLocalName()) {
                case "mutatieType": {
                    mutatieInhoud.mutatieType = cursor.collectDescendantText().trim();
                    break;
                }
                case "gebied": {
                    mutatieInhoud.gebied = cursor.collectDescendantText().trim();
                    break;
                }
                case "leveringsId": {
                    mutatieInhoud.leveringsId = cursor.collectDescendantText().trim();
                    break;
                }
                case "objectTypen": {
                    SMInputCursor c = cursor.childElementCursor();
                    while (c.getNext() != null) {
                        mutatieInhoud.objectTypen.add(c.collectDescendantText().trim());
                    }
                    break;
                }
            }
        }
        return mutatieInhoud;
    }

    protected XmlStreamGeometryReader buildGeometryReader() {
        return new XmlStreamGeometryReader((XMLStreamReader)this.cursor.getStreamReader());
    }

    protected SMInputFactory buildSMInputFactory() {
        XMLInputFactory xmlInputFactory = XMLInputFactory.newFactory();
        log.trace((Object)("StAX XMLInputFactory: " + xmlInputFactory.getClass().getName()));
        xmlInputFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        xmlInputFactory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        return new SMInputFactory(xmlInputFactory);
    }

    @Override
    public Iterator<BGTObject> iterator() {
        return new Iterator<BGTObject>(){
            SMEvent event;
            private final Queue<BGTObject> buffer;
            {
                this.event = BGTObjectStreamer.this.cursor.getCurrEvent();
                this.buffer = new LinkedList<BGTObject>();
            }

            @Override
            public boolean hasNext() {
                if (BGTObjectStreamer.this.isMutaties && !BGTObjectStreamer.this.hasMutatieGroep) {
                    return false;
                }
                if (!this.buffer.isEmpty()) {
                    return true;
                }
                if (this.event != null) {
                    return true;
                }
                try {
                    this.event = BGTObjectStreamer.this.cursor.getNext();
                    return this.event != null;
                }
                catch (XMLStreamException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public BGTObject next() {
                try {
                    SMInputCursor cityObjectMemberChild;
                    if (!this.buffer.isEmpty()) {
                        return this.buffer.remove();
                    }
                    if (BGTObjectStreamer.this.isMutaties && !BGTObjectStreamer.this.hasMutatieGroep) {
                        throw new IllegalStateException("No items");
                    }
                    if (this.event == null && !this.hasNext()) {
                        throw new IllegalStateException("No more items");
                    }
                    this.event = null;
                    HashMap<String, Object> attributes = new HashMap<String, Object>();
                    String gmlIdPreviousVersion = null;
                    BGTObject.MutatieStatus mutatieStatus = BGTObject.MutatieStatus.WORDT;
                    if (BGTObjectStreamer.this.isMutaties) {
                        SMInputCursor mutatie = BGTObjectStreamer.this.cursor.childElementCursor().advance();
                        String mutatieNaam = mutatie.getLocalName();
                        if (!mutatieNaam.equals("wijziging") && !mutatieNaam.equals("toevoeging")) {
                            throw new IllegalStateException("Ongeldig mutatieGroep child element: " + mutatie.getQName());
                        }
                        mutatie = mutatie.childElementCursor().advance();
                        if (mutatieNaam.equals("wijziging")) {
                            assert (mutatie.getLocalName().equals("was"));
                            gmlIdPreviousVersion = BGTSchema.fixUUID(mutatie.getAttrValue("id"));
                            if (mutatie.getNext() == null) {
                                throw new IllegalStateException("Mutaties 'was' zonder 'wordt' worden niet ondersteund voor BGT");
                            }
                            assert (mutatie.getLocalName().equals("wordt"));
                            mutatieStatus = BGTObject.MutatieStatus.WAS_WORDT;
                        } else if (mutatieNaam.equals("toevoeging")) {
                            assert (mutatie.getLocalName().equals("wordt"));
                        } else {
                            throw new IllegalStateException("Ongeldig mutatie element: " + mutatie.getLocalName());
                        }
                        cityObjectMemberChild = mutatie.childElementCursor(BGT_OBJECT).advance().childElementCursor(CITYGML_CITY_OBJECT_MEMBER).advance().childElementCursor().advance();
                    } else {
                        cityObjectMemberChild = BGTObjectStreamer.this.cursor.childElementCursor().advance();
                    }
                    String name = cityObjectMemberChild.getLocalName();
                    BGTObjectType bgtObjectType = BGTSchema.getInstance().getObjectTypeByName(name);
                    if (bgtObjectType == null) {
                        throw new IllegalArgumentException("Onbekend object type: " + name);
                    }
                    Location location = cityObjectMemberChild.getCursorLocation();
                    attributes.put("gmlId", BGTSchema.fixUUID(cityObjectMemberChild.getAttrValue(BGTObjectStreamer.NS_GML, "id")));
                    SMInputCursor attributesCursor = cityObjectMemberChild.childElementCursor();
                    Collection collectionAttribute = null;
                    while (attributesCursor.getNext() != null) {
                        String attributeName = attributesCursor.getLocalName();
                        Object parsedAttribute = BGTObjectStreamer.this.parseIMGeoAttribute(attributesCursor);
                        if (parsedAttribute instanceof BGTObject) {
                            ArrayList<BGTObject> oneToMany = (ArrayList<BGTObject>)attributes.get(attributeName);
                            if (oneToMany == null) {
                                oneToMany = new ArrayList<BGTObject>();
                                attributes.put(attributeName, oneToMany);
                            }
                            oneToMany.add((BGTObject)parsedAttribute);
                            continue;
                        }
                        if (parsedAttribute instanceof Collection) {
                            if (collectionAttribute != null) {
                                throw new IllegalStateException("Only a single collection attribute is supported");
                            }
                            collectionAttribute = (Collection)parsedAttribute;
                            continue;
                        }
                        attributes.put(attributeName, parsedAttribute);
                    }
                    if (collectionAttribute != null && !collectionAttribute.isEmpty()) {
                        int index = 0;
                        for (Map collectionItem : collectionAttribute) {
                            HashMap<String, Object> attributesForCollectionItem = new HashMap<String, Object>(attributes);
                            attributesForCollectionItem.putAll(collectionItem);
                            attributesForCollectionItem.put("idx", index++);
                            this.buffer.add(new BGTObject(bgtObjectType, attributesForCollectionItem, location));
                        }
                        return this.buffer.remove();
                    }
                    return new BGTObject(bgtObjectType, attributes, location, mutatieStatus, gmlIdPreviousVersion);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    private Object parseIMGeoAttribute(SMInputCursor attribute) throws XMLStreamException, FactoryException, IOException {
        if ("true".equals(attribute.getAttrValue("http://www.w3.org/2001/XMLSchema-instance", "nil"))) {
            return null;
        }
        if (attribute.hasLocalName("identificatie")) {
            String id = attribute.descendantElementCursor(LOKAAL_ID).advance().collectDescendantText().trim();
            return id.replaceAll("-", "");
        }
        if (BGTObjectStreamer.isGeometryElement(attribute.getLocalName())) {
            attribute.childElementCursor().advance();
            Geometry geom = this.geometryReader.readGeometry();
            geom.setSRID(28992);
            return geom;
        }
        if (attribute.hasLocalName("nummeraanduidingreeks")) {
            Location location = attribute.getCursorLocation();
            Map<String, Object> nummeraanduidingreeks = this.parseNummeraanduidingreeks(attribute);
            return new BGTObject(BGTSchema.getInstance().getObjectTypeByName("nummeraanduidingreeks"), nummeraanduidingreeks, location);
        }
        if (attribute.hasLocalName("openbareRuimteNaam")) {
            return this.parseOpenbareRuimteNaam(attribute);
        }
        return attribute.collectDescendantText().trim();
    }

    private static boolean isGeometryElement(String localName) {
        return localName.startsWith("geometrie") || localName.startsWith("kruinlijn");
    }

    private Map<String, Object> parseNummeraanduidingreeks(SMInputCursor cursor) throws XMLStreamException, FactoryException, IOException {
        HashMap<String, Object> label = new HashMap<String, Object>();
        cursor = cursor.childElementCursor(CAPITALIZED_NUMMERAANDUIDINGREEKS).advance().childElementCursor();
        while (cursor.getNext() != null) {
            if (cursor.getQName().equals(LOWERCASE_NUMMERAANDUIDINGREEKS)) {
                SMInputCursor labelChilds = cursor.childElementCursor(LABEL).advance().childElementCursor();
                while (labelChilds.getNext() != null) {
                    if (labelChilds.hasLocalName("tekst")) {
                        label.put("tekst", labelChilds.collectDescendantText().trim());
                        continue;
                    }
                    if (!labelChilds.hasLocalName("positie")) continue;
                    SMInputCursor labelPositie = labelChilds.childElementCursor(LABELPOSITIE).advance();
                    SMInputCursor labelPositieChilds = labelPositie.childElementCursor();
                    while (labelPositieChilds.getNext() != null) {
                        if (labelPositieChilds.hasLocalName("plaatsingspunt")) {
                            labelPositieChilds.childElementCursor().advance();
                            labelPositieChilds.getStreamReader().require(1, NS_GML, "Point");
                            Geometry geom = this.geometryReader.readGeometry();
                            geom.setSRID(28992);
                            label.put("plaatsingspunt", geom);
                            continue;
                        }
                        if (!labelPositieChilds.hasLocalName("hoek")) continue;
                        String hoek = labelPositieChilds.collectDescendantText().trim();
                        label.put("hoek", Double.parseDouble(hoek));
                    }
                }
                continue;
            }
            label.put(cursor.getLocalName(), cursor.collectDescendantText().trim());
        }
        return label;
    }

    private List<Map<String, Object>> parseOpenbareRuimteNaam(SMInputCursor cursor) throws XMLStreamException, FactoryException, IOException {
        cursor = cursor.childElementCursor(LABEL).advance().childElementCursor();
        ArrayList<Map<String, Object>> posities = new ArrayList<Map<String, Object>>();
        String tekst = null;
        while (cursor.getNext() != null) {
            if (cursor.getLocalName().equals("tekst")) {
                tekst = cursor.collectDescendantText().trim();
                continue;
            }
            if (!cursor.getLocalName().equals("positie")) continue;
            HashMap<String, String> positie = new HashMap<String, String>();
            positie.put("tekst", tekst);
            posities.add(positie);
            SMInputCursor positieCursor = cursor.childElementCursor().advance().childElementCursor();
            while (positieCursor.getNext() != null) {
                if (positieCursor.getLocalName().equals("plaatsingspunt")) {
                    positieCursor.childElementCursor().advance();
                    Geometry geom = this.geometryReader.readGeometry();
                    geom.setSRID(28992);
                    positie.put("plaatsingspunt", (String)geom);
                    continue;
                }
                positie.put(positieCursor.getLocalName(), positieCursor.collectDescendantText().trim());
            }
        }
        return posities;
    }

    public static class MutatieInhoud {
        private String mutatieType;
        private String gebied;
        private String leveringsId;
        private final List<String> objectTypen = new ArrayList<String>();

        public String getMutatieType() {
            return this.mutatieType;
        }

        public String getGebied() {
            return this.gebied;
        }

        public String getLeveringsId() {
            return this.leveringsId;
        }

        public List<String> getObjectTypen() {
            return this.objectTypen;
        }
    }
}

