/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.bgt.loader;

import java.time.Duration;
import java.time.Instant;
import java.util.function.Consumer;
import java.util.function.Supplier;
import nl.b3p.brmo.bgt.loader.Utils;
import nl.b3p.brmo.bgt.schema.BGTObjectTableWriter;
import nl.b3p.brmo.bgt.schema.BGTSchemaMapper;
import nl.b3p.brmo.schema.ObjectTableWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProgressReporter
implements Consumer<ObjectTableWriter.Progress> {
    private static final Log log = LogFactory.getLog(ProgressReporter.class);
    private final Instant start = Instant.now();
    private Long totalBytes;
    private Supplier<Long> totalBytesReadFunction;
    private String currentFileName;
    private Instant currentFileStart = Instant.now();
    private Long currentFileSize;

    public Instant getStart() {
        return this.start;
    }

    public Long getTotalBytes() {
        return this.totalBytes;
    }

    public Supplier<Long> getTotalBytesReadFunction() {
        return this.totalBytesReadFunction;
    }

    public String getCurrentFileName() {
        return this.currentFileName;
    }

    public Instant getCurrentFileStart() {
        return this.currentFileStart;
    }

    public Long getCurrentFileSize() {
        return this.currentFileSize;
    }

    public void setTotalBytes(long totalBytes) {
        this.totalBytes = totalBytes;
    }

    public void setTotalBytesReadFunction(Supplier<Long> totalBytesReadFunction) {
        this.totalBytesReadFunction = totalBytesReadFunction;
    }

    public void startNewFile(String name, Long size) {
        this.currentFileName = name;
        this.currentFileSize = size;
        this.currentFileStart = Instant.now();
        this.status(Utils.getMessageFormattedString("progress.initializing", name));
    }

    protected void log(String msg) {
        log.info((Object)msg);
    }

    protected void status(String msg) {
        log.debug((Object)msg);
    }

    @Override
    public void accept(ObjectTableWriter.Progress genericProgress) {
        BGTObjectTableWriter.BGTProgress progress = (BGTObjectTableWriter.BGTProgress)genericProgress;
        switch (progress.getStage()) {
            case LOAD_OBJECTS: {
                if (progress.getObjectCount() != 0L) break;
                this.status(Utils.getMessageFormattedString("progress.loading", this.currentFileName));
                break;
            }
            case CREATE_PRIMARY_KEY: {
                this.status(Utils.getMessageFormattedString("progress.create_primary_key", this.currentFileName));
                break;
            }
            case CREATE_GEOMETRY_INDEX: {
                this.status(Utils.getMessageFormattedString("progress.create_geometry_indexes", this.currentFileName));
                break;
            }
            case FINISHED: {
                String counts;
                double loadTimeSeconds = (double)Duration.between(this.currentFileStart, Instant.now()).toMillis() / 1000.0;
                if (progress.getMutatieInhoud() != null && "delta".equals(progress.getMutatieInhoud().getMutatieType())) {
                    counts = String.format("%s, %s: %,6d", progress.getWriter().isCurrentObjectsOnly() ? String.format("%s: %,6d", Utils.getBundleString("progress.removed"), progress.getObjectRemovedCount()) : String.format("%s: %,6d", Utils.getBundleString("progress.updated"), progress.getObjectUpdatedCount()), Utils.getBundleString("progress.added"), progress.getObjectCount());
                } else {
                    String historicObjects = "";
                    if (log.isDebugEnabled() && progress.getWriter().isCurrentObjectsOnly()) {
                        historicObjects = String.format(", %,10d %s", progress.getHistoricObjectsCount(), Utils.getBundleString("progress.historic_skipped"));
                    }
                    counts = String.format("%,10d %s%s", progress.getObjectCount(), Utils.getBundleString("progress.objects"), historicObjects);
                }
                this.log(String.format("%-" + (BGTSchemaMapper.getInstance().getMaxTableLength() + 8) + "s %10s, %s, %,7.0f %s/s", this.currentFileName, Utils.formatTimeSince(this.currentFileStart), counts, loadTimeSeconds > 0.0 ? (double)progress.getObjectCount() / loadTimeSeconds : 0.0, Utils.getBundleString("progress.objects")));
                break;
            }
        }
    }

    public void reportTotalSummary() {
        this.log(Utils.getMessageFormattedString("progress.finished", Utils.formatTimeSince(this.start)));
    }
}

