/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.util;

import java.io.IOException;
import java.io.InputStream;

public class ResumingInputStream
extends InputStream {
    public static final int DEFAULT_MAX_TRIES = 5;
    private final StreamAtStartPositionProvider streamProvider;
    private long position;
    private InputStream delegate = null;
    private int maxReadTries;
    private int totalRetries = 0;
    private int currentDelegateBytesRead = 0;

    public ResumingInputStream(StreamAtStartPositionProvider streamProvider) {
        this(streamProvider, 0L);
    }

    public ResumingInputStream(StreamAtStartPositionProvider streamProvider, long startPosition) {
        this(streamProvider, startPosition, 5);
    }

    public ResumingInputStream(StreamAtStartPositionProvider streamProvider, long startPosition, int maxReadTries) {
        this.streamProvider = streamProvider;
        this.position = startPosition;
        this.maxReadTries = maxReadTries;
    }

    public long getPosition() {
        return this.position;
    }

    public int getCurrentDelegateBytesRead() {
        return this.currentDelegateBytesRead;
    }

    public int getTotalRetries() {
        return this.totalRetries;
    }

    public int getMaxReadTries() {
        return this.maxReadTries;
    }

    public void setMaxReadTries(int maxReadTries) {
        this.maxReadTries = maxReadTries;
    }

    private void ensureDelegateOpen() throws IOException {
        if (this.delegate == null) {
            this.delegate = this.streamProvider.get(this.position, this.totalRetries, null);
        }
    }

    @Override
    public int read() throws IOException {
        byte[] b = new byte[1];
        int read = this.read(b, 0, 1);
        if (read == 1) {
            return b[0];
        }
        return read;
    }

    @Override
    public int available() throws IOException {
        this.ensureDelegateOpen();
        return this.delegate.available();
    }

    @Override
    public void close() throws IOException {
        if (this.delegate != null) {
            this.delegate.close();
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.ensureDelegateOpen();
        int tries = 0;
        while (true) {
            try {
                int count = this.delegate.read(b, off, len);
                if (count == -1) {
                    return count;
                }
                this.position += (long)count;
                this.currentDelegateBytesRead += count;
                return count;
            }
            catch (IOException e) {
                this.onReadException(++tries, e);
                ++this.totalRetries;
                this.retryingAfterReadException(tries, this.totalRetries);
                try {
                    this.delegate.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.delegate = this.streamProvider.get(this.position, this.totalRetries, e);
                this.currentDelegateBytesRead = 0;
                continue;
            }
            break;
        }
    }

    protected void onReadException(int tries, IOException cause) throws IOException {
        if (tries > this.maxReadTries) {
            throw new IOException("Max read tries (" + this.maxReadTries + ") exceeded", cause);
        }
    }

    protected void retryingAfterReadException(int tries, int totalRetries) {
    }

    @FunctionalInterface
    public static interface StreamAtStartPositionProvider {
        public InputStream get(long var1, int var3, Exception var4) throws IOException;
    }
}

