/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.bgt.download.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.ArrayList;
import java.util.StringJoiner;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import nl.b3p.brmo.bgt.download.client.ApiClient;
import nl.b3p.brmo.bgt.download.client.ApiException;
import nl.b3p.brmo.bgt.download.client.ApiResponse;
import nl.b3p.brmo.bgt.download.client.Configuration;
import nl.b3p.brmo.bgt.download.client.Pair;
import nl.b3p.brmo.bgt.download.model.GetDeltasResponse;

public class DeltaApi {
    private final HttpClient memberVarHttpClient;
    private final ObjectMapper memberVarObjectMapper;
    private final String memberVarBaseUri;
    private final Consumer<HttpRequest.Builder> memberVarInterceptor;
    private final Duration memberVarReadTimeout;
    private final Consumer<HttpResponse<InputStream>> memberVarResponseInterceptor;
    private final Consumer<HttpResponse<String>> memberVarAsyncResponseInterceptor;

    public DeltaApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DeltaApi(ApiClient apiClient) {
        this.memberVarHttpClient = apiClient.getHttpClient();
        this.memberVarObjectMapper = apiClient.getObjectMapper();
        this.memberVarBaseUri = apiClient.getBaseUri();
        this.memberVarInterceptor = apiClient.getRequestInterceptor();
        this.memberVarReadTimeout = apiClient.getReadTimeout();
        this.memberVarResponseInterceptor = apiClient.getResponseInterceptor();
        this.memberVarAsyncResponseInterceptor = apiClient.getAsyncResponseInterceptor();
    }

    protected ApiException getApiException(String operationId, HttpResponse<InputStream> response) throws IOException {
        String body = response.body() == null ? null : new String(response.body().readAllBytes());
        String message = this.formatExceptionMessage(operationId, response.statusCode(), body);
        return new ApiException(response.statusCode(), message, response.headers(), body);
    }

    private String formatExceptionMessage(String operationId, int statusCode, String body) {
        if (body == null || body.isEmpty()) {
            body = "[no body]";
        }
        return operationId + " call failed with: " + statusCode + " - " + body;
    }

    public GetDeltasResponse getDeltas(@Nullable String afterDeltaId, @Nullable Integer page, @Nullable Integer count) throws ApiException {
        ApiResponse<GetDeltasResponse> localVarResponse = this.getDeltasWithHttpInfo(afterDeltaId, page, count);
        return localVarResponse.getData();
    }

    public ApiResponse<GetDeltasResponse> getDeltasWithHttpInfo(@Nullable String afterDeltaId, @Nullable Integer page, @Nullable Integer count) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getDeltasRequestBuilder(afterDeltaId, page, count);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getDeltas", localVarResponse);
            }
            if (localVarResponse.body() == null) {
                return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
            }
            String responseBody = new String(localVarResponse.body().readAllBytes());
            localVarResponse.body().close();
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody.isBlank() ? null : (GetDeltasResponse)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<GetDeltasResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder getDeltasRequestBuilder(@Nullable String afterDeltaId, @Nullable Integer page, @Nullable Integer count) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/delta";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName = "after-delta-id";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("after-delta-id", afterDeltaId));
        localVarQueryParameterBaseName = "page";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("page", page));
        localVarQueryParameterBaseName = "count";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("count", count));
        if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            if (localVarQueryStringJoiner.length() != 0) {
                queryJoiner.add(localVarQueryStringJoiner.toString());
            }
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }
}

