/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.schema;

import java.sql.Connection;
import java.sql.SQLException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import nl.b3p.brmo.schema.ObjectType;
import nl.b3p.brmo.schema.SchemaObjectInstance;
import nl.b3p.brmo.schema.SchemaSQLMapper;
import nl.b3p.brmo.schema.mapping.ArrayAttributeMapping;
import nl.b3p.brmo.schema.mapping.AttributeColumnMapping;
import nl.b3p.brmo.schema.mapping.GeometryAttributeColumnMapping;
import nl.b3p.brmo.sql.GeometryHandlingPreparedStatementBatch;
import nl.b3p.brmo.sql.LoggingQueryRunner;
import nl.b3p.brmo.sql.PostGISCopyInsertBatch;
import nl.b3p.brmo.sql.QueryBatch;
import nl.b3p.brmo.sql.dialect.PostGISDialect;
import nl.b3p.brmo.sql.dialect.SQLDialect;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ObjectTableWriter {
    private static final Log log = LogFactory.getLog(ObjectTableWriter.class);
    private final Connection connection;
    private final SQLDialect dialect;
    private final SchemaSQLMapper schemaSQLMapper;
    private int batchSize = 100;
    private boolean multithreading = true;
    private boolean usePgCopy = true;
    private Integer objectLimit = null;
    private boolean linearizeCurves = false;
    private boolean createSchema = false;
    private boolean dropIfExists = true;
    private boolean createKeysAndIndexes = true;
    private String tablePrefix = "";
    private Consumer<Progress> progressUpdater;
    private Progress progress = null;
    private Throwable exceptionFromWorkerThread = null;
    private final Runnable worker = () -> {
        try {
            block3: while (true) {
                ArrayList<SchemaObjectInstance> objects = new ArrayList<SchemaObjectInstance>(this.progress.objectsToWrite.size());
                objects.add(this.progress.objectsToWrite.take());
                this.progress.objectsToWrite.drainTo(objects);
                Iterator iterator = objects.iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block3;
                    SchemaObjectInstance object = (SchemaObjectInstance)iterator.next();
                    if (object.getObjectType() == null) {
                        return;
                    }
                    this.addObjectToBatch(object, true);
                }
                break;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Throwable e) {
            log.error((Object)"Exception in object writing thread", e);
            this.setExceptionFromWorkerThread(e);
        }
    };
    private Thread workerThread = null;

    public ObjectTableWriter(Connection connection, SQLDialect dialect, SchemaSQLMapper schemaSQLMapper) {
        this.connection = connection;
        this.dialect = dialect;
        this.schemaSQLMapper = schemaSQLMapper;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public SQLDialect getDialect() {
        return this.dialect;
    }

    public SchemaSQLMapper getSchemaSQLMapper() {
        return this.schemaSQLMapper;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public boolean isMultithreading() {
        return this.multithreading;
    }

    public void setMultithreading(boolean multithreading) {
        this.multithreading = multithreading;
    }

    public boolean isUsePgCopy() {
        return this.usePgCopy;
    }

    public void setUsePgCopy(boolean usePgCopy) {
        this.usePgCopy = usePgCopy;
    }

    public Integer getObjectLimit() {
        return this.objectLimit;
    }

    public void setObjectLimit(Integer objectLimit) {
        this.objectLimit = objectLimit;
    }

    public boolean isLinearizeCurves() {
        return this.linearizeCurves;
    }

    public void setLinearizeCurves(boolean linearizeCurves) {
        this.linearizeCurves = linearizeCurves;
    }

    public boolean isCreateSchema() {
        return this.createSchema;
    }

    public void setCreateSchema(boolean createSchema) {
        this.createSchema = createSchema;
    }

    public boolean isDropIfExists() {
        return this.dropIfExists;
    }

    public void setDropIfExists(boolean dropIfExists) {
        this.dropIfExists = dropIfExists;
    }

    public boolean isCreateKeysAndIndexes() {
        return this.createKeysAndIndexes;
    }

    public void setCreateKeysAndIndexes(boolean createKeysAndIndexes) {
        this.createKeysAndIndexes = createKeysAndIndexes;
    }

    public String getTablePrefix() {
        return this.tablePrefix;
    }

    public void setTablePrefix(String tablePrefix) {
        this.tablePrefix = tablePrefix;
    }

    public Consumer<Progress> getProgressUpdater() {
        return this.progressUpdater;
    }

    public void setProgressUpdater(Consumer<Progress> progressUpdater) {
        this.progressUpdater = progressUpdater;
    }

    public Progress getProgress() {
        return this.progress;
    }

    public void setProgress(Progress progress) {
        this.progress = progress;
    }

    protected void prepareDatabaseForObject(SchemaObjectInstance object) throws Exception {
        this.getInsertBatch(object);
    }

    protected synchronized QueryBatch getInsertBatch(SchemaObjectInstance object) throws Exception {
        Map<ObjectType, QueryBatch> insertBatches = this.progress.insertBatches;
        if (insertBatches.isEmpty() && this.progress.initialLoad) {
            if (this.isCreateSchema()) {
                LoggingQueryRunner qr = new LoggingQueryRunner();
                for (String sql : Stream.concat(this.schemaSQLMapper.getCreateTableStatements(object.getObjectType(), this.dialect, this.tablePrefix, this.dropIfExists), this.schemaSQLMapper.getCreateGeometryMetadataStatements(object.getObjectType(), this.dialect, this.tablePrefix)).collect(Collectors.toList())) {
                    qr.update(this.connection, sql);
                }
            } else {
                this.truncateTable(this.connection, object.getObjectType());
                for (ObjectType oneToManyObjectType : object.getObjectType().getOneToManyAttributeObjectTypes()) {
                    this.truncateTable(this.connection, oneToManyObjectType);
                }
            }
        }
        if (!insertBatches.containsKey(object.getObjectType())) {
            QueryBatch queryBatch;
            if (this.dialect instanceof PostGISDialect && this.usePgCopy) {
                sql = this.buildPgCopySql(object, this.progress.initialLoad);
                boolean bufferCopy = !this.progress.singleTableInserts;
                queryBatch = new PostGISCopyInsertBatch(this.connection, sql, this.batchSize, this.dialect, bufferCopy, this.linearizeCurves);
            } else {
                sql = this.buildInsertSql(object);
                Boolean[] parameterIsGeometry = (Boolean[])object.getObjectType().getDirectNonDefaultInsertAttributes().stream().map(attributeColumnMapping -> attributeColumnMapping instanceof GeometryAttributeColumnMapping).toArray(Boolean[]::new);
                queryBatch = new GeometryHandlingPreparedStatementBatch(this.connection, sql, this.batchSize, this.dialect, parameterIsGeometry, this.linearizeCurves);
            }
            insertBatches.put(object.getObjectType(), queryBatch);
        }
        return insertBatches.get(object.getObjectType());
    }

    protected synchronized QueryBatch getArrayAttributeInsertBatch(SchemaObjectInstance object, ArrayAttributeMapping attribute) throws Exception {
        Map<Pair<ObjectType, ArrayAttributeMapping>, QueryBatch> insertBatches = this.progress.arrayAttributeInsertBatches;
        ImmutablePair batchKey = ImmutablePair.of((Object)object.getObjectType(), (Object)attribute);
        if (!insertBatches.containsKey(batchKey)) {
            String sql = this.buildInsertSql(object.getObjectType(), attribute);
            Boolean[] parameterIsGeometry = (Boolean[])object.getObjectType().getDirectNonDefaultInsertAttributes().stream().map(attributeColumnMapping -> attributeColumnMapping instanceof GeometryAttributeColumnMapping).toArray(Boolean[]::new);
            GeometryHandlingPreparedStatementBatch queryBatch = new GeometryHandlingPreparedStatementBatch(this.connection, sql, this.batchSize, this.dialect, parameterIsGeometry, this.linearizeCurves);
            insertBatches.put((Pair<ObjectType, ArrayAttributeMapping>)batchKey, queryBatch);
        }
        return insertBatches.get(batchKey);
    }

    protected void addObjectToBatch(SchemaObjectInstance object) throws Exception {
        if (this.progress.firstObject) {
            this.progress.setSingleTableInserts(this.progress.initialLoad && object.getObjectType().hasOnlyDirectAttributes());
            this.progress.firstObject = false;
        }
        try {
            this.addObjectToBatch(object, false);
        }
        catch (Throwable e) {
            String message = "Exception writing object to database, object: ";
            if (this.getBatchSize() > 1) {
                message = "Exception adding parameters to database write batch, may be caused by previous batches. Object: ";
            }
            throw new Exception(message + String.valueOf(object), e);
        }
    }

    private void addObjectToBatch(SchemaObjectInstance object, boolean fromWorkerThread) throws Throwable {
        if (this.multithreading && !fromWorkerThread) {
            while (this.exceptionFromWorkerThread == null) {
                if (!this.progress.objectsToWrite.offer(object, 500L, TimeUnit.MILLISECONDS)) continue;
                return;
            }
            throw this.exceptionFromWorkerThread;
        }
        QueryBatch batch = this.getInsertBatch(object);
        Map<String, Object> attributes = object.getAttributes();
        ArrayList<Object> params = new ArrayList<Object>();
        for (AttributeColumnMapping attributeColumnMapping : object.getObjectType().getDirectNonDefaultInsertAttributes()) {
            Object attribute = attributes.get(attributeColumnMapping.getName());
            params.add(attributeColumnMapping.toQueryParameter(attribute, this.getDialect()));
        }
        batch.addBatch(params.toArray());
        for (ObjectType oneToManyAttribute : object.getObjectType().getOneToManyAttributeObjectTypes()) {
            List objects = (List)attributes.get(oneToManyAttribute.getName());
            if (objects == null || objects.isEmpty()) continue;
            for (int i = 0; i < objects.size(); ++i) {
                SchemaObjectInstance oneToMany = (SchemaObjectInstance)objects.get(i);
                String tableName = this.schemaSQLMapper.getTableNameForObjectType(object.getObjectType(), "");
                String idColumnName = object.getObjectType().getPrimaryKeys().get(0).getName();
                oneToMany.getAttributes().put(this.schemaSQLMapper.getColumnNameForObjectType(oneToMany.getObjectType(), tableName + idColumnName), object.getAttributes().get(idColumnName));
                oneToMany.getAttributes().put("idx", i);
                Object eindRegistratie = object.getAttributes().get("eindRegistratie");
                oneToMany.getAttributes().put(this.schemaSQLMapper.getColumnNameForObjectType(oneToMany.getObjectType(), tableName + "eindRegistratie"), eindRegistratie != null);
                this.addObjectToBatch(oneToMany, fromWorkerThread);
            }
        }
        for (ArrayAttributeMapping arrayAttribute : object.getObjectType().getArrayAttributes()) {
            this.insertArrayAttribute(object, arrayAttribute);
        }
        this.updateProgress();
    }

    private void insertArrayAttribute(SchemaObjectInstance object, ArrayAttributeMapping attribute) throws Exception {
        Set values = (Set)object.getAttributes().get(attribute.getName());
        if (values != null && !values.isEmpty()) {
            QueryBatch insertBatch = this.getArrayAttributeInsertBatch(object, attribute);
            Object[] keys = object.getObjectType().getPrimaryKeys().stream().map(key -> {
                try {
                    return key.toQueryParameter(object.getAttributes().get(key.getName()), this.getDialect());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }).toArray();
            for (Object value : values) {
                Object[] params = new Object[keys.length + 1];
                System.arraycopy(keys, 0, params, 0, keys.length);
                params[params.length - 1] = value;
                insertBatch.addBatch(params);
            }
        }
    }

    private synchronized Throwable getExceptionFromWorkerThread() {
        return this.exceptionFromWorkerThread;
    }

    private synchronized void setExceptionFromWorkerThread(Throwable exceptionFromWorkerThread) {
        this.exceptionFromWorkerThread = exceptionFromWorkerThread;
    }

    public void abortWorkerThread() throws Exception {
        if (this.workerThread != null) {
            this.progress.objectsToWrite.clear();
            this.endOfObjects();
        }
    }

    protected void updateProgress(Stage stage) {
        if (this.progress != null) {
            this.progress.stage = stage;
            this.updateProgress(true);
        }
    }

    protected void updateProgress() {
        this.updateProgress(false);
    }

    private void updateProgress(boolean always) {
        boolean timeForProgress;
        if (this.progressUpdater == null) {
            return;
        }
        boolean bl = timeForProgress = this.progress.lastProgressUpdate == null || this.progress.objectCount % 500L == 0L && (double)Duration.between(this.progress.lastProgressUpdate, Instant.now()).getNano() > 2.5E8;
        if (always || timeForProgress) {
            this.progressUpdater.accept(this.progress);
            this.progress.lastProgressUpdate = Instant.now();
        }
    }

    private void truncateTable(Connection c, ObjectType objectType) throws SQLException {
        new LoggingQueryRunner().execute(c, String.format("truncate table %s", this.schemaSQLMapper.getTableNameForObjectType(objectType, this.tablePrefix)), new Object[0]);
    }

    private String buildInsertSql(SchemaObjectInstance object) {
        StringBuilder sql = new StringBuilder("insert into ");
        String tableName = this.schemaSQLMapper.getTableNameForObjectType(object.getObjectType(), this.tablePrefix);
        sql.append(tableName).append("(");
        sql.append(this.buildColumnList(object.getObjectType()));
        sql.append(") values (");
        String paramPlaceholders = object.getObjectType().getDirectNonDefaultInsertAttributes().stream().map(c -> "?").collect(Collectors.joining(", "));
        sql.append(paramPlaceholders).append(")");
        return sql.toString();
    }

    private String buildInsertSql(ObjectType objectType, ArrayAttributeMapping attribute) {
        String referencingKeys = objectType.getPrimaryKeys().stream().map(pk -> this.schemaSQLMapper.getColumnNameForObjectType(objectType, pk.getName())).collect(Collectors.joining(", "));
        return String.format("insert into %s (%s, %s) values (%s)", this.schemaSQLMapper.getTableNameForArrayAttribute(objectType, attribute, this.tablePrefix), referencingKeys, this.schemaSQLMapper.getColumnNameForObjectType(objectType, attribute.getName()), String.join((CharSequence)", ", Collections.nCopies(objectType.getPrimaryKeys().size() + 1, "?")));
    }

    private String buildPgCopySql(SchemaObjectInstance object, boolean initialLoad) {
        String tableName = this.schemaSQLMapper.getTableNameForObjectType(object.getObjectType(), this.tablePrefix);
        String copySql = "copy " + tableName + "(" + this.buildColumnList(object.getObjectType()) + ") from stdin";
        return copySql + (initialLoad ? " with freeze" : "");
    }

    private String buildColumnList(ObjectType objectType) {
        return objectType.getDirectNonDefaultInsertAttributes().stream().map(column -> this.schemaSQLMapper.getColumnNameForObjectType(objectType, column.getName())).collect(Collectors.joining(", "));
    }

    protected void start(Progress progress) throws SQLException {
        this.progress = progress;
        this.getConnection().setAutoCommit(false);
        if (this.multithreading) {
            this.workerThread = new Thread(this.worker);
            this.workerThread.start();
        }
    }

    protected void endOfObjects() throws Exception {
        if (this.workerThread != null) {
            this.progress.objectsToWrite.put(new SchemaObjectInstance(null, Collections.emptyMap()));
            this.workerThread.join();
        }
    }

    protected void complete() throws Exception {
        for (QueryBatch batch : this.progress.insertBatches.values()) {
            batch.executeBatch();
        }
        for (QueryBatch batch : this.progress.arrayAttributeInsertBatches.values()) {
            batch.executeBatch();
        }
        if (this.isCreateSchema() && this.isCreateKeysAndIndexes() && this.progress.initialLoad) {
            for (ObjectType objectType : this.progress.insertBatches.keySet()) {
                this.createKeys(objectType);
            }
            for (ObjectType objectType : this.progress.insertBatches.keySet()) {
                this.createIndexes(objectType);
            }
        }
        this.connection.commit();
        this.updateProgress(Stage.FINISHED);
    }

    public void createKeys(ObjectType objectType) throws Exception {
        LoggingQueryRunner qr = new LoggingQueryRunner();
        this.updateProgress(Stage.CREATE_PRIMARY_KEY);
        for (String sql : this.schemaSQLMapper.getCreatePrimaryKeyStatements(objectType, this.dialect, this.tablePrefix, false).collect(Collectors.toList())) {
            qr.update(this.connection, sql);
        }
    }

    public void createIndexes(ObjectType objectType) throws Exception {
        LoggingQueryRunner qr = new LoggingQueryRunner();
        this.updateProgress(Stage.CREATE_GEOMETRY_INDEX);
        for (String sql : this.schemaSQLMapper.getCreateGeometryIndexStatements(objectType, this.dialect, this.tablePrefix, false).collect(Collectors.toList())) {
            qr.update(this.connection, sql);
        }
    }

    protected void closeBatches() {
        this.progress.insertBatches.values().forEach(QueryBatch::closeQuietly);
        this.progress.arrayAttributeInsertBatches.values().forEach(QueryBatch::closeQuietly);
    }

    public class Progress {
        private Map<ObjectType, QueryBatch> insertBatches = new HashMap<ObjectType, QueryBatch>();
        private Map<Pair<ObjectType, ArrayAttributeMapping>, QueryBatch> arrayAttributeInsertBatches = new HashMap<Pair<ObjectType, ArrayAttributeMapping>, QueryBatch>();
        private boolean initialLoad = true;
        private boolean firstObject = true;
        private boolean singleTableInserts = false;
        private final BlockingQueue<SchemaObjectInstance> objectsToWrite;
        private Stage stage = Stage.PARSE_INPUT;
        private long objectCount = 0L;
        private Instant lastProgressUpdate = null;

        protected Progress() {
            int batchSize = ObjectTableWriter.this.getBatchSize();
            if (batchSize <= 0) {
                batchSize = 2500;
            }
            this.objectsToWrite = new ArrayBlockingQueue<SchemaObjectInstance>(batchSize);
        }

        public void setSingleTableInserts(boolean singleTableInserts) {
            this.singleTableInserts = singleTableInserts;
        }

        public void setInitialLoad(boolean initialLoad) {
            this.initialLoad = initialLoad;
        }

        public ObjectTableWriter getWriter() {
            return ObjectTableWriter.this;
        }

        public Stage getStage() {
            return this.stage;
        }

        public long getObjectCount() {
            return this.objectCount;
        }

        public void setObjectCount(long objectCount) {
            this.objectCount = objectCount;
        }

        public void incrementObjectCount() {
            ++this.objectCount;
        }
    }

    public static enum Stage {
        PARSE_INPUT,
        LOAD_OBJECTS,
        CREATE_PRIMARY_KEY,
        CREATE_GEOMETRY_INDEX,
        FINISHED;

    }
}

