/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.util.http;

import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nl.b3p.brmo.util.ResumingInputStream;
import nl.b3p.brmo.util.http.HttpClientWrapper;
import nl.b3p.brmo.util.http.HttpClientWrappers;
import nl.b3p.brmo.util.http.HttpResponseWrapper;
import nl.b3p.brmo.util.http.HttpStartRangeInputStreamProvider;

public class HttpSeekableByteChannel
implements SeekableByteChannel {
    private static final int DEFAULT_SEEK_BUFFER_SIZE = 16384;
    private static final int DEFAULT_MAX_DISCARD_SIZE = 16384;
    private static final int READ_BUFFER_SIZE = 8192;
    private URI uri;
    private final HttpClientWrapper httpClientWrapper;
    private final UnaryOperator<ResumingInputStream> resumingInputStreamWrapper;
    private final int seekBufferSize;
    private byte[] seekBuffer;
    private byte[] buffer;
    private final int maxDiscardSize;
    private long position = 0L;
    private int httpRequestCount = 0;
    private long bytesRead = 0L;
    private Long newPosition;
    private Long contentLength;
    private ResumingInputStream currentHttpResponseBodyInputStream;
    private boolean debug = false;

    public HttpSeekableByteChannel(URI uri) {
        this(uri, HttpClientWrappers.getDefault());
    }

    public HttpSeekableByteChannel(URI uri, HttpClientWrapper httpClientWrapper) {
        this(uri, httpClientWrapper, UnaryOperator.identity(), 16384, 16384);
    }

    public HttpSeekableByteChannel(URI uri, HttpClientWrapper httpClientWrapper, UnaryOperator<ResumingInputStream> resumingInputStreamWrapper, int seekBufferSize, int maxDiscardSize) {
        this.uri = uri;
        this.httpClientWrapper = httpClientWrapper;
        this.resumingInputStreamWrapper = resumingInputStreamWrapper;
        this.seekBufferSize = seekBufferSize;
        this.maxDiscardSize = maxDiscardSize;
    }

    public int getHttpRequestCount() {
        return this.httpRequestCount;
    }

    public long getBytesRead() {
        return this.bytesRead;
    }

    public void setURI(URI uri) {
        this.uri = uri;
    }

    public HttpSeekableByteChannel withDebug(boolean debug) {
        this.debug = debug;
        return this;
    }

    @Override
    public long position() throws IOException {
        return this.newPosition != null ? this.newPosition : this.position;
    }

    @Override
    public SeekableByteChannel position(long newPosition) throws IOException {
        this.newPosition = newPosition;
        return this;
    }

    @Override
    public long size() throws IOException {
        if (this.contentLength == null) {
            HttpResponseWrapper response;
            try {
                response = this.httpClientWrapper.request(this.uri, "Range", "bytes=0-0");
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
            if (response.getStatusCode() != 206) {
                throw new IOException("Expected 206 Partial Content, but got status code " + response.getStatusCode() + " getting content length for " + String.valueOf(this.uri));
            }
            String contentRange = response.getHeader("Content-Range");
            if (contentRange == null) {
                throw new IOException("Missing Content-Range response header getting content length for " + String.valueOf(this.uri));
            }
            Matcher m = Pattern.compile("bytes\\s+\\d+-\\d+/(\\d+)").matcher(contentRange);
            if (!m.matches()) {
                throw new IOException("Invalid Content-Range response header value \"" + contentRange + "\" getting content length for " + String.valueOf(this.uri));
            }
            this.contentLength = Long.parseLong(m.group(1));
            if (this.contentLength < 0L) {
                throw new IOException("Invalid Content-Range response header value \"" + contentRange + "\" getting content length for " + String.valueOf(this.uri));
            }
        }
        return this.contentLength;
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        int read;
        if (this.newPosition != null && this.newPosition != this.position) {
            if (this.currentHttpResponseBodyInputStream != null) {
                if (this.newPosition > this.position && this.newPosition - this.position <= (long)this.maxDiscardSize) {
                    if (this.debug) {
                        System.out.printf(" [Discard %d bytes to seek forward from position %d to %d ] ", this.newPosition - this.position, this.position, this.newPosition);
                    }
                    if (this.seekBuffer == null) {
                        this.seekBuffer = new byte[this.seekBufferSize];
                    }
                    int remaining = (int)(this.newPosition - this.position);
                    while ((remaining -= this.currentHttpResponseBodyInputStream.read(this.seekBuffer, 0, Math.min(remaining, this.seekBuffer.length))) > 0) {
                    }
                } else {
                    try {
                        this.currentHttpResponseBodyInputStream.close();
                    }
                    catch (IOException remaining) {
                        // empty catch block
                    }
                    this.currentHttpResponseBodyInputStream = null;
                }
            }
            this.position = this.newPosition;
            this.newPosition = null;
        }
        if (this.currentHttpResponseBodyInputStream == null) {
            if (this.debug) {
                System.out.print(" [GET at position " + this.position + "] ");
            }
            ++this.httpRequestCount;
            this.currentHttpResponseBodyInputStream = (ResumingInputStream)this.resumingInputStreamWrapper.apply(new ResumingInputStream(new HttpStartRangeInputStreamProvider(this.uri, this.httpClientWrapper, this.contentLength).assumeAcceptsRanges(true), this.position));
        }
        if (byteBuffer.hasArray()) {
            read = this.currentHttpResponseBodyInputStream.read(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
            if (read > 0) {
                byteBuffer.position(byteBuffer.position() + read);
            }
        } else {
            if (this.buffer == null) {
                this.buffer = new byte[8192];
            }
            if ((read = this.currentHttpResponseBodyInputStream.read(this.buffer, 0, Math.min(byteBuffer.remaining(), this.buffer.length))) > 0) {
                byteBuffer.put(this.buffer, 0, read);
            }
        }
        if (read > 0) {
            this.position += (long)read;
            this.bytesRead += (long)read;
        }
        return read;
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public void close() throws IOException {
        if (this.currentHttpResponseBodyInputStream != null) {
            this.currentHttpResponseBodyInputStream.close();
            this.seekBuffer = null;
            this.buffer = null;
        }
    }

    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SeekableByteChannel truncate(long l) throws IOException {
        throw new UnsupportedOperationException();
    }
}

