/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.bgt.download.client;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import nl.b3p.brmo.bgt.download.client.ApiClient;

public class Configuration {
    public static final String VERSION = "v1";
    private static final AtomicReference<ApiClient> defaultApiClient = new AtomicReference();
    private static volatile Supplier<ApiClient> apiClientFactory = ApiClient::new;

    public static ApiClient getDefaultApiClient() {
        ApiClient client = defaultApiClient.get();
        if (client == null) {
            client = defaultApiClient.updateAndGet(val -> {
                if (val != null) {
                    return val;
                }
                return apiClientFactory.get();
            });
        }
        return client;
    }

    public static void setDefaultApiClient(ApiClient apiClient) {
        defaultApiClient.set(apiClient);
    }

    public static void setApiClientFactory(Supplier<ApiClient> factory) {
        apiClientFactory = Objects.requireNonNull(factory);
    }

    private Configuration() {
    }
}

