/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.sql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.StatementConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoggingQueryRunner
extends QueryRunner {
    private static final Log LOG = LogFactory.getLog(LoggingQueryRunner.class);

    public LoggingQueryRunner() {
    }

    public LoggingQueryRunner(boolean pmdKnownBroken) {
        super(pmdKnownBroken);
    }

    public LoggingQueryRunner(DataSource ds) {
        super(ds);
    }

    public LoggingQueryRunner(StatementConfiguration stmtConfig) {
        super(stmtConfig);
    }

    public LoggingQueryRunner(DataSource ds, boolean pmdKnownBroken) {
        super(ds, pmdKnownBroken);
    }

    public LoggingQueryRunner(DataSource ds, StatementConfiguration stmtConfig) {
        super(ds, stmtConfig);
    }

    public LoggingQueryRunner(DataSource ds, boolean pmdKnownBroken, StatementConfiguration stmtConfig) {
        super(ds, pmdKnownBroken, stmtConfig);
    }

    private void log(String type, String sql, Object params) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)(type + ": " + sql + (String)(params != null ? ", params: " + String.valueOf(params) : "")));
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(type + ": " + sql));
        }
    }

    public int[] batch(Connection conn, String sql, Object[][] params) throws SQLException {
        this.log("batch", sql, params);
        return super.batch(conn, sql, params);
    }

    public int[] batch(String sql, Object[][] params) throws SQLException {
        this.log("batch", sql, params);
        return super.batch(sql, params);
    }

    @Deprecated
    public <T> T query(Connection conn, String sql, Object param, ResultSetHandler<T> rsh) throws SQLException {
        this.log("query", sql, param);
        return (T)super.query(conn, sql, param, rsh);
    }

    @Deprecated
    public <T> T query(Connection conn, String sql, Object[] params, ResultSetHandler<T> rsh) throws SQLException {
        this.log("query", sql, params);
        return (T)super.query(conn, sql, params, rsh);
    }

    public <T> T query(Connection conn, String sql, ResultSetHandler<T> rsh, Object ... params) throws SQLException {
        this.log("query", sql, params);
        return (T)super.query(conn, sql, rsh, params);
    }

    public <T> T query(Connection conn, String sql, ResultSetHandler<T> rsh) throws SQLException {
        this.log("query", sql, null);
        return (T)super.query(conn, sql, rsh);
    }

    @Deprecated
    public <T> T query(String sql, Object param, ResultSetHandler<T> rsh) throws SQLException {
        this.log("query", sql, param);
        return (T)super.query(sql, param, rsh);
    }

    @Deprecated
    public <T> T query(String sql, Object[] params, ResultSetHandler<T> rsh) throws SQLException {
        this.log("query", sql, params);
        return (T)super.query(sql, params, rsh);
    }

    public <T> T query(String sql, ResultSetHandler<T> rsh, Object ... params) throws SQLException {
        this.log("query", sql, params);
        return (T)super.query(sql, rsh, params);
    }

    public <T> T query(String sql, ResultSetHandler<T> rsh) throws SQLException {
        this.log("query", sql, null);
        return (T)super.query(sql, rsh);
    }

    public int update(Connection conn, String sql) throws SQLException {
        this.log("update", sql, null);
        return super.update(conn, sql);
    }

    public int update(Connection conn, String sql, Object param) throws SQLException {
        this.log("update", sql, param);
        return super.update(conn, sql, param);
    }

    public int update(Connection conn, String sql, Object ... params) throws SQLException {
        this.log("update", sql, params);
        return super.update(conn, sql, params);
    }

    public int update(String sql) throws SQLException {
        this.log("update", sql, null);
        return super.update(sql);
    }

    public int update(String sql, Object param) throws SQLException {
        this.log("update", sql, param);
        return super.update(sql, param);
    }

    public int update(String sql, Object ... params) throws SQLException {
        this.log("update", sql, params);
        return super.update(sql, params);
    }

    public <T> T insert(String sql, ResultSetHandler<T> rsh) throws SQLException {
        this.log("insert", sql, null);
        return (T)super.insert(sql, rsh);
    }

    public <T> T insert(String sql, ResultSetHandler<T> rsh, Object ... params) throws SQLException {
        this.log("insert", sql, params);
        return (T)super.insert(sql, rsh, params);
    }

    public <T> T insert(Connection conn, String sql, ResultSetHandler<T> rsh) throws SQLException {
        this.log("insert", sql, null);
        return (T)super.insert(conn, sql, rsh);
    }

    public <T> T insert(Connection conn, String sql, ResultSetHandler<T> rsh, Object ... params) throws SQLException {
        this.log("insert", sql, params);
        return (T)super.insert(conn, sql, rsh, params);
    }

    public <T> T insertBatch(String sql, ResultSetHandler<T> rsh, Object[][] params) throws SQLException {
        this.log("insertBatch", sql, params);
        return (T)super.insertBatch(sql, rsh, params);
    }

    public <T> T insertBatch(Connection conn, String sql, ResultSetHandler<T> rsh, Object[][] params) throws SQLException {
        this.log("insertBatch", sql, params);
        return (T)super.insertBatch(conn, sql, rsh, params);
    }

    public int execute(Connection conn, String sql, Object ... params) throws SQLException {
        this.log("execute", sql, params);
        return super.execute(conn, sql, params);
    }

    public int execute(String sql, Object ... params) throws SQLException {
        this.log("execute", sql, params);
        return super.execute(sql, params);
    }

    public <T> List<T> execute(Connection conn, String sql, ResultSetHandler<T> rsh, Object ... params) throws SQLException {
        this.log("execute", sql, params);
        return super.execute(conn, sql, rsh, params);
    }

    public <T> List<T> execute(String sql, ResultSetHandler<T> rsh, Object ... params) throws SQLException {
        this.log("execute", sql, params);
        return super.execute(sql, rsh, params);
    }
}

