/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.util.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.stream.Stream;
import nl.b3p.brmo.util.ResumingInputStream;
import nl.b3p.brmo.util.http.HttpClientWrapper;
import nl.b3p.brmo.util.http.HttpClientWrappers;
import nl.b3p.brmo.util.http.HttpResponseWrapper;

public class HttpStartRangeInputStreamProvider
implements ResumingInputStream.StreamAtStartPositionProvider {
    private final URI uri;
    private final HttpClientWrapper httpClientWrapper;
    private final Long contentLength;
    private boolean first = true;
    private String ifRange;
    private String acceptRanges;
    private boolean assumeAcceptsRanges = false;

    public HttpStartRangeInputStreamProvider(URI uri) {
        this(uri, HttpClientWrappers.getDefault());
    }

    public HttpStartRangeInputStreamProvider(URI uri, HttpClientWrapper httpClientWrapper) {
        this(uri, httpClientWrapper, null);
    }

    public HttpStartRangeInputStreamProvider(URI uri, HttpClientWrapper httpClientWrapper, Long contentLength) {
        this.uri = uri;
        this.httpClientWrapper = httpClientWrapper;
        this.contentLength = contentLength;
    }

    public HttpStartRangeInputStreamProvider assumeAcceptsRanges(boolean assumeAcceptsRanges) {
        this.assumeAcceptsRanges = assumeAcceptsRanges;
        return this;
    }

    public boolean isAssumeAcceptsRanges() {
        return this.assumeAcceptsRanges;
    }

    public void setAssumeAcceptsRanges(boolean assumeAcceptsRanges) {
        this.assumeAcceptsRanges = assumeAcceptsRanges;
    }

    public Long getContentLength() {
        return this.contentLength;
    }

    @Override
    public InputStream get(long position, int totalRetries, Exception causeForRetry) throws IOException {
        HttpResponseWrapper response;
        ArrayList<String[]> headers = new ArrayList<String[]>();
        if (position > 0L && !this.first) {
            if (!this.assumeAcceptsRanges && !"bytes".equals(this.acceptRanges)) {
                throw new IOException("Exception reading from HTTP server and resume not supported", causeForRetry);
            }
            if (this.ifRange == null) {
                throw new IOException("Exception reading from HTTP server, cannot resume HTTP request reliably: no strong ETag or Last-Modified", causeForRetry);
            }
            headers.add(new String[]{"If-Range", this.ifRange});
        }
        if (position > 0L) {
            headers.add(new String[]{"Range", "bytes=" + position + "-" + String.valueOf(this.contentLength != null ? Long.valueOf(this.contentLength - 1L) : "")});
        }
        this.first = false;
        try {
            response = this.httpClientWrapper.request(this.uri, (String[])headers.stream().flatMap(header -> Stream.of(header[0], header[1])).toArray(String[]::new));
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        if (position > 0L) {
            if (response.getStatusCode() != 206) {
                throw new RuntimeException("Error retrying HTTP request at position " + position + ": expected 206 response status but got " + response.getStatusCode());
            }
        } else if (response.getStatusCode() != 200) {
            throw new RuntimeException("HTTP status code: " + response.getStatusCode());
        }
        String lastModified = response.getHeader("Last-Modified");
        String eTag = response.getHeader("ETag");
        if (eTag != null) {
            if (!eTag.startsWith("W/")) {
                this.ifRange = eTag;
            }
        } else {
            this.ifRange = lastModified;
        }
        this.acceptRanges = response.getHeader("Accept-Ranges");
        return response.getResponseBody();
    }
}

