/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.verschil.stripes;

import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.ErrorResolution;
import net.sourceforge.stripes.action.GET;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.RestActionBean;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.validation.SimpleError;
import net.sourceforge.stripes.validation.Validate;
import net.sourceforge.stripes.validation.ValidationError;
import net.sourceforge.stripes.validation.ValidationErrorHandler;
import net.sourceforge.stripes.validation.ValidationErrors;
import net.sourceforge.stripes.validation.ValidationMethod;
import net.sourceforge.stripes.validation.ValidationState;
import nl.b3p.brmo.verschil.util.ConfigUtil;
import nl.b3p.brmo.verschil.util.ResultSetJSONSerializer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@RestActionBean
@UrlBinding(value="/rest/{location}")
public class MutatiesActionBean
implements ActionBean,
ValidationErrorHandler {
    private static final Log LOG = LogFactory.getLog(MutatiesActionBean.class);
    private final SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
    @Validate(required=true, mask="\\d{4}-\\d{2}-\\d{2}")
    private Date van;
    @Validate(mask="\\d{4}-\\d{2}-\\d{2}")
    private Date tot = new Date();
    @Validate
    private String f = "json";
    private ActionBeanContext context;
    private long copied;
    private boolean errorCondition = false;
    private static final String TAX_JOIN_CLAUSE_TBL = "tax.belastingplichtige tax ON ( " + "      q.ka_kad_gemeentecode = trim(LEADING '0' from tax.gemeentecode) " + "  AND q.ka_sectie           = trim(tax.sectie) " + "  AND q.ka_perceelnummer    = trim(LEADING '0' from tax.perceelnummer) " + "  AND coalesce(q.ka_appartementsindex,'') = coalesce(trim(LEADING '0' from tax.appartementsindex),'') )";
    private static final String TAX_JOIN_CLAUSE_VW = "tax.belastingplichtige tax ON ( " + "      q.gemeentecode  = trim(LEADING '0' from tax.gemeentecode) " + "  AND q.sectie        = trim(tax.sectie) " + "  AND q.perceelnummer = trim(LEADING '0' from tax.perceelnummer) " + "  AND coalesce(q.appartementsindex,'') = coalesce(trim(LEADING '0' from tax.appartementsindex),'') )";
    private String VIEW_KOZ_RECHTHEBBENDE = "vb_koz_rechth";
    private String VIEW_KAD_ONRRND_ZK_ADRES = "vb_kad_onrrnd_zk_adres";
    private String VIEW_KAD_ONRRND_ZK_ARCHIEF = "vb_kad_onrrnd_zk_archief";
    private int JDBC_FETCH_SIZE = 0;
    private int QRY_TIMEOUT = 600;
    private String SEP = ";";
    private String QUOTE = "";
    private final String NL = System.getProperty("line.separator");

    @ValidationMethod(when=ValidationState.NO_ERRORS)
    public void validateVanBeforeTot(ValidationErrors errors) {
        if (this.tot.before(this.van)) {
            errors.addGlobalError((ValidationError)new SimpleError("`van` datum is voor `tot` datum", new Object[0]));
        }
    }

    public Resolution handleValidationErrors(ValidationErrors errors) throws Exception {
        StringBuilder msg = new StringBuilder("Validatiefout(en): \n");
        if (errors.hasFieldErrors()) {
            errors.entrySet().stream().forEach(entry -> ((List)entry.getValue()).stream().map(e -> {
                if (LOG.isDebugEnabled()) {
                    msg.append("veld: ").append((String)entry.getKey()).append(", waarde: ");
                    msg.append(e.getFieldValue()).append(", melding: ");
                }
                return e;
            }).forEach(e -> msg.append(e.getMessage(Locale.ROOT)).append(" \n")));
        }
        if (errors.get((Object)"__stripes_global_error") != null) {
            ((List)errors.get((Object)"__stripes_global_error")).stream().forEach(e -> msg.append(e.getMessage(Locale.ROOT)));
        }
        return new ErrorResolution(400, msg.toString());
    }

    @GET
    @DefaultHandler
    public Resolution get() throws IOException {
        this.errorCondition = false;
        LOG.trace((Object)("`get` met params: van=" + this.van + " tot=" + this.tot + ", format: " + this.f));
        LOG.info((Object)String.format("Uitvoeren opdracht met params: van=%s tot=%s", this.df.format(this.van), this.df.format(this.tot)));
        this.initParams();
        Path workPath = Files.createTempDirectory(Paths.get(System.getProperty("java.io.tmpdir"), new String[0]), "brkmutsvc", new FileAttribute[0]);
        File workDir = workPath.toFile();
        workDir.deleteOnExit();
        File workZip = Files.createTempFile("brkmutsvc", ".zip", new FileAttribute[0]).toFile();
        workZip.deleteOnExit();
        LOG.debug((Object)"Ophalen nieuwe onroerende zaken");
        long nwOnrrgd = this.getNieuweOnroerendGoed(workDir);
        LOG.info((Object)("Aantal nieuwe onroerende zaken is: " + nwOnrrgd));
        LOG.debug((Object)"Ophalen gekoppelde objecten");
        long gekoppeld = this.getGekoppeldeObjecten(workDir);
        LOG.info((Object)("Aantal gekoppeld objecten: " + gekoppeld));
        LOG.debug((Object)"Ophalen vervallen objecten");
        long vervallen = this.getVervallenOnroerendGoed(workDir);
        LOG.info((Object)("Aantal vervallen objecten: " + vervallen));
        LOG.debug((Object)"Ophalen object verkopen");
        long verkopen = this.getVerkopen(workDir);
        LOG.info((Object)("Aantal object verkopen: " + verkopen));
        LOG.debug((Object)"Ophalen oppervlakte veranderd objecten");
        long oppVeranderd = this.getGewijzigdeOpp(workDir);
        LOG.info((Object)("Aantal oppervlakte veranderd objecten: " + oppVeranderd));
        LOG.debug((Object)"Ophalen nieuwe subjecten");
        long nwSubject = this.getNieuweSubjecten(workDir);
        LOG.info((Object)("Aantal nieuwe subjecten: " + nwSubject));
        LOG.debug((Object)"Ophalen BSN aangepast");
        long bsn = this.getBSNAangevuld(workDir);
        LOG.info((Object)("Aantal aangepast bsn: " + bsn));
        if (nwOnrrgd < 0L || gekoppeld < 0L || vervallen < 0L || verkopen < 0L || oppVeranderd < 0L || nwSubject < 0L || bsn < 0L) {
            this.errorCondition = true;
            LOG.trace((Object)("Een van de queries heeft een onverwacht resultaat gegeven, errorCondition=" + this.errorCondition));
        }
        try (ZipOutputStream zs = new ZipOutputStream(Files.newOutputStream(workZip.toPath(), new OpenOption[0]));){
            LOG.debug((Object)("Aanmaken van zip bestand: " + workZip));
            Files.walk(workPath, new FileVisitOption[0]).filter(path -> !Files.isDirectory(path, new LinkOption[0])).forEach(path -> {
                ZipEntry zipEntry = new ZipEntry(workPath.relativize((Path)path).toString());
                try {
                    LOG.debug((Object)("Toevoegen van bestand: " + zipEntry));
                    zs.putNextEntry(zipEntry);
                    Files.copy(path, zs);
                    zs.closeEntry();
                }
                catch (IOException e) {
                    LOG.error((Object)"Probleem tijdens aanmaken van zipfile", (Throwable)e);
                }
            });
        }
        return new /* Unavailable Anonymous Inner Class!! */.setFilename("mutaties_" + this.df.format(this.van) + "_" + this.df.format(this.tot) + ".zip").setAttachment(true).setLastModified(this.tot.getTime());
    }

    private long getNieuweOnroerendGoed(File workDir) {
        StringBuilder sql = new StringBuilder("SELECT DISTINCT ").append("o.kad_identif, ").append("o.dat_beg_geldh, ").append("q.ka_kad_gemeentecode  AS gemeentecode, ").append("q.ka_perceelnummer     AS perceelnummer, ").append("q.ka_deelperceelnummer AS deelperceelnummer, ").append("q.ka_sectie            AS sectie, ").append("q.ka_appartementsindex AS appartementsindex, ").append("tax.kpr_nummer, ").append("bel.bpl_identif, ").append("bel.naam_belastingplichtige, ").append("q.grootte_perceel, ").append("q.x, ").append("q.y, ").append("z.ar_teller            AS aandeel_teller, ").append("z.ar_noemer            AS aandeel_noemer, ").append("z.fk_3avr_aand         AS rechtcode, ").append("avr.omschr_aard_verkregenr_recht AS rechtomschrijving, ").append("h.fk_sc_rh_koz_kad_identif AS ontstaan_uit, ").append("h.aard, ").append("arch.gemeentecode             AS ontstaan_uit_gemeentecode,  ").append("arch.perceelnummer            AS ontstaan_uit_perceelnummer, ").append("arch.deelperceelnummer        AS ontstaan_uit_deelperceelnummer, ").append("arch.sectie                   AS ontstaan_uit_sectie,  ").append("arch.appartementsindex        AS ontstaan_uit_appartementsindex ").append("FROM kad_onrrnd_zk o ").append("LEFT JOIN (SELECT  ").append("  ar.sc_kad_identif, ").append("  ar.ka_kad_gemeentecode, ").append("  ar.ka_perceelnummer, ").append("  null AS ka_deelperceelnummer, ").append("  ar.ka_sectie, ").append("  ar.ka_appartementsindex, ").append("  null AS grootte_perceel, ").append("  null AS x, ").append("  null AS y ").append("FROM app_re ar ").append("UNION ALL SELECT ").append("  p.sc_kad_identif, ").append("  p.ka_kad_gemeentecode, ").append("  p.ka_perceelnummer, ").append("  p.ka_deelperceelnummer, ").append("  p.ka_sectie, ").append("  null AS ka_appartementsindex, ").append("  p.grootte_perceel, ").append("  ST_X(p.plaatscoordinaten_perceel) AS x, ").append("  ST_Y(p.plaatscoordinaten_perceel) AS y ").append("FROM kad_perceel p) q ").append("ON o.kad_identif = q.sc_kad_identif ").append("LEFT JOIN zak_recht z ON o.kad_identif = z.fk_7koz_kad_identif ").append("LEFT JOIN aard_verkregen_recht avr ON z.fk_3avr_aand = avr.aand ").append("LEFT JOIN kad_onrrnd_zk_his_rel h ON o.kad_identif = h.fk_sc_lh_koz_kad_identif ").append("LEFT JOIN mb_kad_onrrnd_zk_archief arch ON h.fk_sc_rh_koz_kad_identif = arch.koz_identif ").append("LEFT JOIN wdd.belastingplichtige bel ON o.kad_identif = bel.sc_kad_identif ").append("LEFT JOIN ").append(TAX_JOIN_CLAUSE_TBL).append(" WHERE z.fk_3avr_aand IN ( '2', '4', '3', '12')  AND '[").append(this.df.format(this.van)).append(",").append(this.df.format(this.tot)).append("]'::DATERANGE @> o.dat_beg_geldh::date ").append(" AND o.kad_identif NOT IN (").append("     SELECT kad_identif FROM kad_onrrnd_zk_archief ").append(") AND z.fk_8pes_sc_identif IS NOT NULL ").append(" AND tax.kpr_nummer IS NULL");
        switch (this.f) {
            case "csv": {
                return this.queryToCSV(workDir, "NieuweOnroerendGoed.csv", sql.toString(), new String[0]);
            }
        }
        return this.queryToJson(workDir, "NieuweOnroerendGoed.json", "nieuw", sql.toString(), new String[0]);
    }

    private long getGekoppeldeObjecten(File workDir) {
        StringBuilder sql = new StringBuilder("SELECT DISTINCT ").append("adr.koz_identif, ").append("adr.gemeentecode, ").append("adr.sectie, ").append("adr.perceelnummer, ").append("adr.appartementsindex, ").append("adr.loc_omschr, ").append("adr.benoemdobj_identif, ").append("adr.straatnaam, ").append("adr.huisnummer, ").append("adr.huisletter, ").append("adr.huisnummer_toev, ").append("adr.woonplaats, ").append("adr.postcode ").append("FROM ").append(this.VIEW_KAD_ONRRND_ZK_ADRES).append(" adr ").append(" WHERE '[").append(this.df.format(this.van)).append(",").append(this.df.format(this.tot)).append("]'::DATERANGE @> adr.begin_geldigheid::date ").append("AND adr.koz_identif NOT IN (SELECT kad_identif FROM kad_onrrnd_zk_archief WHERE '").append(this.df.format(this.van)).append("'::date < dat_beg_geldh::date) ORDER BY adr.koz_identif");
        switch (this.f) {
            case "csv": {
                return this.queryToCSV(workDir, "GekoppeldeObjecten.csv", sql.toString(), new String[0]);
            }
        }
        return this.queryToJson(workDir, "GekoppeldeObjecten.json", "koppeling", sql.toString(), new String[0]);
    }

    private long getVervallenOnroerendGoed(File workDir) {
        StringBuilder sql = new StringBuilder("SELECT DISTINCT ON (arch.koz_identif) ").append("arch.koz_identif, ").append("arch.eind_geldigheid, ").append("arch.gemeentecode, ").append("arch.sectie, ").append("arch.perceelnummer, ").append("arch.deelperceelnummer, ").append("arch.appartementsindex ").append("FROM ").append(this.VIEW_KAD_ONRRND_ZK_ARCHIEF).append(" arch ").append("WHERE '[").append(this.df.format(this.van)).append(",").append(this.df.format(this.tot)).append("]'::DATERANGE @> arch.eind_geldigheid::date ").append("AND arch.koz_identif NOT IN (SELECT kad_identif FROM kad_onrrnd_zk) ").append("ORDER BY arch.koz_identif, arch.eind_geldigheid::date DESC");
        switch (this.f) {
            case "csv": {
                return this.queryToCSV(workDir, "VervallenOnroerendGoed.csv", sql.toString(), new String[0]);
            }
        }
        return this.queryToJson(workDir, "VervallenOnroerendGoed.json", "vervallen", sql.toString(), new String[0]);
    }

    private long getGewijzigdeOpp(File workDir) {
        StringBuilder sql = new StringBuilder("SELECT DISTINCT ON (za.kad_identif) ").append("za.kad_identif, ").append("k.ka_kad_gemeentecode AS gemeentecode, ").append("k.ka_sectie AS sectie, ").append("k.ka_perceelnummer AS perceelnummer, ").append("k.ka_deelperceelnummer AS deelperceelnummer, ").append("za.dat_beg_geldh, ").append("pa.grootte_perceel AS opp_oud, ").append("k.grootte_perceel  AS opp_actueel ").append("FROM kad_onrrnd_zk_archief za, kad_perceel_archief pa, kad_perceel k ").append("WHERE '[").append(this.df.format(this.van)).append(",").append(this.df.format(this.tot)).append("]'::DATERANGE @> za.dat_beg_geldh::DATE ").append("AND za.dat_beg_geldh    = pa.sc_dat_beg_geldh ").append("AND za.kad_identif      = pa.sc_kad_identif ").append("AND za.kad_identif      = k.sc_kad_identif ").append("AND pa.grootte_perceel != k.grootte_perceel ").append("AND za.kad_identif IN ( SELECT kad_identif FROM kad_onrrnd_zk ").append("WHERE '[").append(this.df.format(this.van)).append(",").append(this.df.format(this.tot)).append("]'::DATERANGE @> dat_beg_geldh::DATE ) ").append("ORDER BY za.kad_identif, za.dat_beg_geldh DESC");
        switch (this.f) {
            case "csv": {
                return this.queryToCSV(workDir, "GewijzigdeOpp.csv", sql.toString(), new String[0]);
            }
        }
        return this.queryToJson(workDir, "GewijzigdeOpp.json", "gewijzigdeopp", sql.toString(), new String[0]);
    }

    private long getVerkopen(File workDir) {
        StringBuilder sql = new StringBuilder("SELECT DISTINCT ").append("bron.ref_id, ").append("bron.datum::text as verkoopdatum, ").append("tax.gemeentecode, ").append("tax.sectie, ").append("tax.perceelnummer, ").append("tax.deelperceelnummer, ").append("tax.appartementsindex, ").append("kpr_nummer, ").append("z.ar_teller AS aandeel_teller, ").append("z.ar_noemer AS aandeel_noemer, ").append("z.fk_3avr_aand AS rechtcode, ").append("avr.omschr_aard_verkregenr_recht AS rechtomschrijving ").append("FROM ( ").append("  SELECT brondocument.ref_id, max(brondocument.datum) AS datum FROM brondocument WHERE brondocument.omschrijving = 'Akte van Koop en Verkoop' GROUP BY brondocument.ref_id) bron ").append("LEFT JOIN (SELECT  ").append("  ar.sc_kad_identif, ").append("  ar.ka_kad_gemeentecode, ").append("  ar.ka_perceelnummer, ").append("  null AS ka_deelperceelnummer, ").append("  ar.ka_sectie, ").append("  ar.ka_appartementsindex ").append("FROM app_re ar ").append("UNION ALL SELECT ").append("  p.sc_kad_identif, ").append("  p.ka_kad_gemeentecode, ").append("  p.ka_perceelnummer, ").append("  p.ka_deelperceelnummer, ").append("  p.ka_sectie, ").append("  null AS ka_appartementsindex ").append("FROM kad_perceel p) q ").append("ON bron.ref_id=q.sc_kad_identif::text ").append("LEFT JOIN zak_recht z ON bron.ref_id = z.fk_7koz_kad_identif::text ").append("LEFT JOIN aard_verkregen_recht avr ON z.fk_3avr_aand = avr.aand ").append("LEFT JOIN ").append(TAX_JOIN_CLAUSE_TBL).append("WHERE '[").append(this.df.format(this.van)).append(",").append(this.df.format(this.tot)).append("]'::DATERANGE @> bron.datum ").append("AND z.fk_8pes_sc_identif IS NOT null ").append(" AND tax.kpr_nummer IS null ");
        switch (this.f) {
            case "csv": {
                return this.queryToCSV(workDir, "Verkopen.csv", sql.toString(), new String[0]);
            }
        }
        return this.queryToJson(workDir, "Verkopen.json", "verkopen", sql.toString(), new String[0]);
    }

    private long getNieuweSubjecten(File workDir) {
        StringBuilder sql = new StringBuilder("SELECT DISTINCT ON (q.naam) ").append("q.begin_geldigheid, ").append("q.soort, ").append("q.geslachtsnaam, ").append("q.voorvoegsel, ").append("q.voornamen, ").append("q.naam, ").append("q.subject_identif, ").append("q.woonadres, ").append("q.geboortedatum, ").append("q.overlijdensdatum, ").append("q.bsn, ").append("q.rsin, ").append("q.kvk_nummer, ").append("q.straatnaam, ").append("q.huisnummer, ").append("q.huisletter, ").append("q.huisnummer_toev, ").append("q.postcode, ").append("q.woonplaats ").append("FROM ").append(this.VIEW_KOZ_RECHTHEBBENDE).append(" q ").append("LEFT JOIN ").append(TAX_JOIN_CLAUSE_VW).append("WHERE '[").append(this.df.format(this.van)).append(",").append(this.df.format(this.tot)).append("]'::DATERANGE @> q.begin_geldigheid::date ").append("AND q.koz_identif NOT IN (SELECT kad_identif FROM kad_onrrnd_zk_archief WHERE '").append(this.df.format(this.van)).append("'::date < dat_beg_geldh::date) ").append("AND tax.kpr_nummer IS NULL ").append("ORDER BY q.naam, q.begin_geldigheid ASC");
        switch (this.f) {
            case "csv": {
                return this.queryToCSV(workDir, "NieuweSubjecten.csv", sql.toString(), new String[0]);
            }
        }
        return this.queryToJson(workDir, "NieuweSubjecten.json", "nieuwe_subjecten", sql.toString(), new String[0]);
    }

    private long getBSNAangevuld(File workDir) {
        StringBuilder sql = new StringBuilder("SELECT ").append("inp.bsn, ").append("inp.sc_identif, ").append("hm.datum::TEXT ").append("FROM ingeschr_nat_prs inp ").append("LEFT JOIN herkomst_metadata hm ON ").append("inp.sc_identif = hm.waarde ").append("WHERE inp.sc_identif IN (SELECT sc_identif FROM ander_nat_prs) ").append("AND hm.tabel='subject' ").append("AND '[").append(this.df.format(this.van)).append(",").append(this.df.format(this.tot)).append("]'::DATERANGE @> datum::DATE ");
        switch (this.f) {
            case "csv": {
                return this.queryToCSV(workDir, "BsnAangevuld.csv", sql.toString(), new String[0]);
            }
        }
        return this.queryToJson(workDir, "BsnAangevuld.json", "bsnaangevuld", sql.toString(), new String[0]);
    }

    private long queryToJson(File workDir, String bestandsNaam, String resultName, String sql, String ... params) {
        long count = -1L;
        if (resultName == null) {
            resultName = "results";
        }
        try (Connection c = ConfigUtil.getDataSourceRsgb().getConnection();){
            c.setReadOnly(true);
            try (PreparedStatement stm = c.prepareStatement(sql);){
                int index = 0;
                for (String p : params) {
                    stm.setString(index++, p);
                }
                SimpleModule module = new SimpleModule();
                ResultSetJSONSerializer serializer = new ResultSetJSONSerializer();
                ObjectMapper mapper = new ObjectMapper();
                stm.setQueryTimeout(this.QRY_TIMEOUT);
                stm.setFetchDirection(1000);
                stm.setFetchSize(this.JDBC_FETCH_SIZE);
                LOG.debug((Object)stm);
                try (ResultSet r = stm.executeQuery();){
                    module.addSerializer((JsonSerializer)serializer);
                    mapper.registerModule((Module)module);
                    ObjectNode objectNode = mapper.createObjectNode();
                    objectNode.putPOJO(resultName, (Object)r);
                    mapper.writeValue((OutputStream)new FileOutputStream(workDir + File.separator + bestandsNaam), (Object)objectNode);
                }
                count = serializer.getCount();
            }
        }
        catch (IOException | SQLException e) {
            LOG.error((Object)String.format("Fout tijdens ophalen en uitschrijven gegevens (sql: %s, bestand: %s %s", sql, workDir, bestandsNaam), (Throwable)e);
        }
        return count;
    }

    private long queryToCSV(File workDir, String bestandsNaam, String sql, String ... params) {
        long count = -1L;
        try (Connection c = ConfigUtil.getDataSourceRsgb().getConnection();){
            c.setReadOnly(true);
            try (PreparedStatement stm = c.prepareStatement(sql);){
                int index = 0;
                for (String p : params) {
                    stm.setString(index++, p);
                }
                stm.setQueryTimeout(this.QRY_TIMEOUT);
                stm.setFetchDirection(1000);
                stm.setFetchSize(this.JDBC_FETCH_SIZE);
                LOG.debug((Object)stm);
                try (ResultSet r = stm.executeQuery();
                     FileOutputStream fos = new FileOutputStream(workDir + File.separator + bestandsNaam);
                     OutputStreamWriter out = new OutputStreamWriter((OutputStream)new BufferedOutputStream(fos), "UTF-8");){
                    ResultSetMetaData metaData = r.getMetaData();
                    int numCols = metaData.getColumnCount();
                    LOG.trace((Object)"uitlezen query resultaat metadata");
                    for (int j = 1; j < numCols + 1; ++j) {
                        ((Writer)out).append(this.QUOTE);
                        ((Writer)out).append(metaData.getColumnName(j));
                        if (j < numCols) {
                            ((Writer)out).append(this.QUOTE);
                            ((Writer)out).append(this.SEP);
                            continue;
                        }
                        ((Writer)out).append(this.QUOTE);
                        ((Writer)out).append(this.NL);
                    }
                    count = 0L;
                    LOG.trace((Object)"uitlezen en uitschrijven query resultaat");
                    while (r.next()) {
                        for (int k = 1; k < numCols + 1; ++k) {
                            String o = r.getString(k);
                            ((Writer)out).append(this.QUOTE);
                            ((Writer)out).append(o != null ? o : "");
                            if (k < numCols) {
                                ((Writer)out).append(this.QUOTE);
                                ((Writer)out).append(this.SEP);
                                continue;
                            }
                            ((Writer)out).append(this.QUOTE);
                            ((Writer)out).append(this.NL);
                        }
                        ++count;
                    }
                }
            }
        }
        catch (IOException | SQLException e) {
            LOG.error((Object)String.format("Fout tijdens ophalen en uitschrijven gegevens (sql: %s, bestand: %s %s", sql, workDir, bestandsNaam), (Throwable)e);
        }
        return count;
    }

    private void initParams() {
        String quote;
        boolean use_mv = Boolean.parseBoolean(this.getContext().getServletContext().getInitParameter("use_mv"));
        if (use_mv) {
            LOG.info((Object)"Gebruik materialized views in de queries.");
            this.VIEW_KOZ_RECHTHEBBENDE = this.VIEW_KOZ_RECHTHEBBENDE.replaceFirst("vb_", "mb_");
            this.VIEW_KAD_ONRRND_ZK_ADRES = this.VIEW_KAD_ONRRND_ZK_ADRES.replaceFirst("vb_", "mb_");
            this.VIEW_KAD_ONRRND_ZK_ARCHIEF = this.VIEW_KAD_ONRRND_ZK_ARCHIEF.replaceFirst("vb_", "mb_");
        } else {
            LOG.warn((Object)"Gebruik reguliere views in de queries (zeer langzaam).");
        }
        try {
            this.JDBC_FETCH_SIZE = Integer.parseInt(this.getContext().getServletContext().getInitParameter("jdbc_fetch_size"));
            LOG.info((Object)String.format("Gebruik fetch size van: %s records", this.JDBC_FETCH_SIZE));
        }
        catch (Exception exception) {
            // empty catch block
        }
        String sep = this.getContext().getServletContext().getInitParameter("csv_separator_char");
        if (sep != null && !sep.isEmpty()) {
            this.SEP = sep;
            LOG.info((Object)String.format("Gebruik '%s' als scheidingsteken in CSV", this.SEP));
        }
        if ((quote = this.getContext().getServletContext().getInitParameter("csv_quote_char")) != null && !quote.isEmpty()) {
            this.QUOTE = quote;
            LOG.info((Object)String.format("Gebruik '%s' als aanhalingsteken in CSV", this.QUOTE));
        }
        try {
            this.QRY_TIMEOUT = Integer.parseInt(this.getContext().getServletContext().getInitParameter("jdbc_query_timeout"));
            LOG.info((Object)String.format("Gebruik query timout van: %s seconden", this.QRY_TIMEOUT));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public Date getVan() {
        return this.van;
    }

    public void setVan(Date van) {
        this.van = van;
    }

    public Date getTot() {
        return this.tot;
    }

    public void setTot(Date tot) {
        this.tot = tot;
    }

    public String getF() {
        return this.f;
    }

    public void setF(String f) {
        this.f = f;
    }

    static /* synthetic */ long access$002(MutatiesActionBean x0, long x1) {
        x0.copied = x1;
        return x0.copied;
    }

    static /* synthetic */ long access$000(MutatiesActionBean x0) {
        return x0.copied;
    }

    static /* synthetic */ Log access$100() {
        return LOG;
    }

    static /* synthetic */ boolean access$200(MutatiesActionBean x0) {
        return x0.errorCondition;
    }
}

