/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.verschil.util;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BasicLoginFilter
implements Filter {
    private static final Log LOG = LogFactory.getLog(BasicLoginFilter.class);
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String BASIC_PREFIX = "Basic ";
    private final List<String> roleNames = new ArrayList();

    public void init(FilterConfig filterConfig) throws ServletException {
        String roleNamesParam = filterConfig.getInitParameter("auth-role-names");
        if (roleNamesParam != null) {
            for (String roleName : roleNamesParam.split(",")) {
                this.roleNames.add(roleName.trim());
            }
        }
        LOG.debug((Object)("beschikbare rollen voor basic auth: " + String.join((CharSequence)", ", this.roleNames)));
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)resp;
        String authHeader = request.getHeader(AUTHORIZATION_HEADER);
        if (authHeader == null || !authHeader.startsWith(BASIC_PREFIX)) {
            LOG.debug((Object)"BASIC Authorization header ontbreekt (401)");
            this.handle401(response);
            return;
        }
        String userPassBase64 = authHeader.substring(BASIC_PREFIX.length());
        String credentials = new String(Base64.getDecoder().decode(userPassBase64), StandardCharsets.UTF_8);
        if (!credentials.contains(":")) {
            LOG.debug((Object)"geen `:` in user:password combo (401)");
            this.handle401(response);
            return;
        }
        String[] values = credentials.split(":", 2);
        String authUser = values[0];
        String authPass = values[1];
        try {
            request.login(authUser, authPass);
        }
        catch (ServletException ex) {
            this.handle403(response);
            return;
        }
        boolean hasRoles = false;
        for (String role : this.roleNames) {
            if (role == null || !request.isUserInRole(role)) continue;
            hasRoles = true;
            break;
        }
        if (!hasRoles) {
            request.logout();
            this.handle403(response);
            return;
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
        request.logout();
    }

    public void destroy() {
    }

    private void handle401(HttpServletResponse response) throws IOException {
        response.addHeader("WWW-Authenticate", "Basic realm=\"REST service Realm\", charset=\"UTF-8\"");
        response.sendError(401, "BASIC authentication credentials invalid.");
    }

    private void handle403(HttpServletResponse response) throws IOException {
        response.sendError(403, "Basic login failed.");
    }
}

