/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.verschil.util;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Date;
import nl.b3p.brmo.verschil.util.NotImplementedException;
import nl.b3p.brmo.verschil.util.ResultSetSerializerException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResultSetJSONSerializer
extends JsonSerializer<ResultSet> {
    private static final Log LOG = LogFactory.getLog(ResultSetJSONSerializer.class);
    private long count = -1L;

    public long getCount() {
        return this.count;
    }

    public Class<ResultSet> handledType() {
        return ResultSet.class;
    }

    public void serialize(ResultSet resultSet, JsonGenerator gen, SerializerProvider serializers) throws ResultSetSerializerException {
        long counted = 0L;
        try {
            LOG.trace((Object)"uitlezen query resultaat metadata");
            ResultSetMetaData metaData = resultSet.getMetaData();
            int numCols = metaData.getColumnCount();
            String[] colNames = new String[numCols];
            int[] colTypes = new int[numCols];
            for (int i = 0; i < numCols; ++i) {
                colNames[i] = metaData.getColumnName(i + 1);
                colTypes[i] = metaData.getColumnType(i + 1);
            }
            gen.writeStartArray();
            LOG.trace((Object)"uitlezen en uitschrijven query resultaat");
            while (resultSet.next()) {
                gen.writeStartObject();
                block18: for (int i = 0; i < colNames.length; ++i) {
                    LOG.trace((Object)("veld naar json: " + colNames[i] + " (" + colTypes[i] + "): " + resultSet.getObject(i + 1)));
                    gen.writeFieldName(colNames[i]);
                    switch (colTypes[i]) {
                        case -5: 
                        case 4: {
                            long l = resultSet.getLong(i + 1);
                            if (resultSet.wasNull()) {
                                gen.writeNull();
                                continue block18;
                            }
                            gen.writeNumber(l);
                            continue block18;
                        }
                        case -6: 
                        case 5: {
                            long l = resultSet.getShort(i + 1);
                            if (resultSet.wasNull()) {
                                gen.writeNull();
                                continue block18;
                            }
                            gen.writeNumber(l);
                            continue block18;
                        }
                        case 2: 
                        case 3: {
                            BigDecimal bd = resultSet.getBigDecimal(i + 1);
                            if (resultSet.wasNull()) {
                                gen.writeNull();
                                continue block18;
                            }
                            gen.writeNumber(bd);
                            continue block18;
                        }
                        case 6: 
                        case 7: 
                        case 8: {
                            double d = resultSet.getDouble(i + 1);
                            if (resultSet.wasNull()) {
                                gen.writeNull();
                                continue block18;
                            }
                            gen.writeNumber(d);
                            continue block18;
                        }
                        case -16: 
                        case -9: 
                        case -1: 
                        case 12: {
                            gen.writeString(resultSet.getString(i + 1));
                            continue block18;
                        }
                        case -7: 
                        case 16: {
                            boolean b = resultSet.getBoolean(i + 1);
                            if (resultSet.wasNull()) {
                                gen.writeNull();
                                continue block18;
                            }
                            gen.writeBoolean(b);
                            continue block18;
                        }
                        case 91: {
                            serializers.defaultSerializeDateValue((Date)resultSet.getDate(i + 1), gen);
                            continue block18;
                        }
                        case 93: {
                            serializers.defaultSerializeDateValue((Date)resultSet.getTime(i + 1), gen);
                            continue block18;
                        }
                        case -4: 
                        case -3: 
                        case -2: {
                            gen.writeBinary(resultSet.getBytes(i + 1));
                            continue block18;
                        }
                        case 2004: {
                            Blob blob = resultSet.getBlob(i + 1);
                            serializers.defaultSerializeValue((Object)blob.getBinaryStream(), gen);
                            blob.free();
                            continue block18;
                        }
                        case 2005: {
                            Clob clob = resultSet.getClob(i);
                            serializers.defaultSerializeValue((Object)clob.getCharacterStream(), gen);
                            clob.free();
                            continue block18;
                        }
                        case 2001: 
                        case 2002: 
                        case 2003: 
                        case 2006: {
                            throw new NotImplementedException("ResultSetJSONSerializer (nog) niet geimplementeerd voor SQL type: " + colTypes[i]);
                        }
                        default: {
                            serializers.defaultSerializeValue(resultSet.getObject(i + 1), gen);
                        }
                    }
                }
                ++counted;
                gen.writeEndObject();
            }
            gen.writeEndArray();
            this.count = counted;
        }
        catch (IOException | RuntimeException | SQLException e) {
            LOG.error((Object)e);
            throw new ResultSetSerializerException((Throwable)e);
        }
    }
}

