<%@include file="/WEB-INF/taglibs.jsp"%>
<%@page contentType="text/html" pageEncoding="UTF-8"%>
<!DOCTYPE html>
<html>
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <title>About BRMO BRK verschil service</title>
        <link href="${contextPath}/styles/main.css" rel="stylesheet">
        <link href="${contextPath}/styles/ext-theme-crisp-all.css" rel="stylesheet">
    </head>
    <body class="x-body">
        <div class="header">
            <h1>B3Partners BRMO BRK verschil service</h1>
            <ul>
                <li><a href="${contextPath}/index.jsp">Home</a></li>
                <li><a href="${contextPath}/logout.jsp">Uitloggen</a></li>
            </ul>
        </div>
        <div class="content">
            <h1>versie informatie</h1>
            <c:set var="version" value="1.0.0"/>
            <table>
                <tr>
                    <td><b>Versie:</b></td>
                    <td>
                        <c:choose>
                            <c:when test="${fn:contains(version,'SNAPSHOT')}">
                                1.0.0-7344b39
                            </c:when>
                            <c:otherwise>
                                1.0.0
                            </c:otherwise>
                        </c:choose>
                        <span id="actuele-versie"><!-- gevuld via jsonp naar GH api --></span>
                    </td>
                </tr>
                <tr>
                    <td><b>Build time:</b></td>
                    <td>14.06.2019 @ 15:42:12 CEST</td>
                </tr>
                <tr>
                    <td><b>Build by:</b></td>
                    <td>Mark Prins</td>
                </tr>
                <tr>
                    <td colspan="2"><h3>Git details</h3></td>
                </tr>
                <tr>
                    <td><b>Git branch:</b></td>
                    <td>7344b39a1284c6f5b752713415d9bd6f3b9971f3</td>
                </tr>
                <tr>
                    <td><b>Git remote url:</b></td>
                    <td>git@github.com:B3Partners/brmo-brkverschil-service.git</td>
                </tr>
                <tr>
                    <td><b>Git commit abbrev id:</b></td>
                    <td>7344b39</td>
                </tr>
                <tr>
                    <td><b>Git commit full id:</b></td>
                    <td>7344b39a1284c6f5b752713415d9bd6f3b9971f3</td>
                </tr>
                <tr>
                    <td><b>Git commit time:</b></td>
                    <td>14.06.2019 @ 15:41:13 CEST</td>
                </tr>
            </table>
            <h2>Runtime informatie</h2>
            <table>
                <tr>
                    <td><b>OS info:</b></td>
                    <td>
                        <jsp:expression>System.getProperty("os.name")</jsp:expression>
                        <jsp:expression>System.getProperty("os.version")</jsp:expression>
                        <jsp:expression>System.getProperty("os.arch")</jsp:expression>
                    </td>
                </tr>
                <tr>
                    <td><b>Java versie:</b></td>
                    <td>
                        <jsp:expression>System.getProperty("java.vendor")</jsp:expression>
                        <jsp:expression>System.getProperty("java.version")</jsp:expression>
                    </td>
                </tr>
                <tr>
                    <td><b>Servlet container info:</b></td>
                    <td><jsp:expression>getServletContext().getServerInfo()</jsp:expression></td>
                </tr>
            </table>
        </div>
        <div class="footer"></div>
        <script>
            // gebruik jsonp om de laatste release op te halen en te tonen
            function v(json){
                var versie=json.data.name;
                var datum = new Date( json.data.published_at).toDateString();
                document.getElementById('actuele-versie').innerHTML = '(laatste release: '+(versie==undefined?versie:"onbekend")+', dd. '+(datum==undefined?datum:"onbekend")+')';
            }

            var scriptTag = document.createElement("script");
            scriptTag.src = "https://api.github.com/repos/b3partners/brmo-brkverschil-service/releases/latest?callback=v";
            document.getElementsByTagName('head')[0].appendChild(scriptTag);
        </script>
    </body>
</html>
