/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec;

import org.geolatte.geom.ByteBuffer;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.Position;
import org.geolatte.geom.codec.AbstractWkbEncoder;
import org.geolatte.geom.codec.WkbVisitor;
import org.geolatte.geom.crs.CoordinateReferenceSystem;
import org.geolatte.geom.crs.CoordinateReferenceSystems;

class PostgisWkbEncoder
extends AbstractWkbEncoder {
    PostgisWkbEncoder() {
    }

    @Override
    protected <P extends Position> int sizeEmptyGeometry(Geometry<P> geometry) {
        return 4;
    }

    @Override
    protected <P extends Position> WkbVisitor<P> newWkbVisitor(ByteBuffer output, Geometry<P> geom) {
        return new PostgisWkbVisitor(output);
    }

    private static class PostgisWkbVisitor<P extends Position>
    extends WkbVisitor<P> {
        private boolean hasWrittenSrid = false;

        PostgisWkbVisitor(ByteBuffer byteBuffer) {
            super(byteBuffer);
        }

        @Override
        protected void writeTypeCodeAndSrid(Geometry<P> geometry, ByteBuffer output) {
            int typeCode = this.getGeometryType(geometry);
            boolean hasSrid = geometry.getSRID() > 0;
            CoordinateReferenceSystem<P> crs = geometry.getCoordinateReferenceSystem();
            if (hasSrid && !this.hasWrittenSrid) {
                typeCode |= 0x20000000;
            }
            if (CoordinateReferenceSystems.hasMeasureAxis(crs)) {
                typeCode |= 0x40000000;
            }
            if (CoordinateReferenceSystems.hasVerticalAxis(crs)) {
                typeCode |= Integer.MIN_VALUE;
            }
            output.putUInt(typeCode);
            if (hasSrid && !this.hasWrittenSrid) {
                output.putInt(geometry.getSRID());
                this.hasWrittenSrid = true;
            }
        }
    }
}

