/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.graph.build.basic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.geotools.graph.build.GraphBuilder;
import org.geotools.graph.structure.Edge;
import org.geotools.graph.structure.Graph;
import org.geotools.graph.structure.Node;
import org.geotools.graph.structure.basic.BasicEdge;
import org.geotools.graph.structure.basic.BasicGraph;
import org.geotools.graph.structure.basic.BasicNode;

public class BasicGraphBuilder
implements GraphBuilder {
    private Graph m_graph;
    private HashSet m_nodes = new HashSet();
    private HashSet m_edges = new HashSet();

    public BasicGraphBuilder() {
        this.m_graph = this.buildGraph();
    }

    @Override
    public Node buildNode() {
        return new BasicNode();
    }

    @Override
    public Edge buildEdge(Node nodeA, Node nodeB) {
        return new BasicEdge(nodeA, nodeB);
    }

    @Override
    public void addNode(Node node) {
        this.m_nodes.add(node);
    }

    @Override
    public void addEdge(Edge edge) {
        edge.getNodeA().add(edge);
        if (!edge.getNodeA().equals(edge.getNodeB())) {
            edge.getNodeB().add(edge);
        }
        this.m_edges.add(edge);
    }

    @Override
    public void removeNode(Node node) {
        ArrayList toRemove = new ArrayList(node.getEdges());
        this.removeEdges(toRemove);
        this.m_nodes.remove(node);
    }

    @Override
    public void removeNodes(Collection nodes) {
        for (Node n : nodes) {
            this.removeNode(n);
        }
    }

    @Override
    public void removeEdge(Edge edge) {
        edge.getNodeA().remove(edge);
        edge.getNodeB().remove(edge);
        this.m_edges.remove(edge);
    }

    @Override
    public void removeEdges(Collection edges) {
        for (Edge e : edges) {
            this.removeEdge(e);
        }
    }

    @Override
    public Graph getGraph() {
        return this.m_graph;
    }

    @Override
    public Object clone(boolean deep) throws Exception {
        GraphBuilder builder = (GraphBuilder)this.getClass().newInstance();
        if (deep) {
            builder.importGraph(this.getGraph());
        }
        return builder;
    }

    @Override
    public void importGraph(Graph g) {
        this.m_nodes = new HashSet(g.getNodes());
        this.m_edges = new HashSet(g.getEdges());
        this.m_graph = this.buildGraph();
    }

    public Collection getNodes() {
        return this.m_nodes;
    }

    public Collection getEdges() {
        return this.m_edges;
    }

    protected Graph buildGraph() {
        return new BasicGraph(this.m_nodes, this.m_edges);
    }
}

