/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.javasimon.proxy.Delegating;
import org.javasimon.proxy.DelegatingMethodInvocation;

public class DelegatingProxyFactory<T>
implements InvocationHandler,
Delegating<T> {
    private final T delegate;

    public DelegatingProxyFactory(T delegate) {
        this.delegate = delegate;
    }

    @Override
    public final Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        return this.invoke(new DelegatingMethodInvocation<T>(this.delegate, proxy, method, args));
    }

    protected Object invoke(DelegatingMethodInvocation<T> delegatingMethodInvocation) throws Throwable {
        return delegatingMethodInvocation.proceed();
    }

    @Override
    public T getDelegate() {
        return this.delegate;
    }

    public Object newProxy(ClassLoader classLoader, Class<?> ... interfaces) {
        return Proxy.newProxyInstance(classLoader, interfaces, (InvocationHandler)this);
    }

    public Object newProxy(Class<?> ... interfaces) {
        return this.newProxy(Thread.currentThread().getContextClassLoader(), interfaces);
    }

    public <X> X newProxy(Class<X> interfaces) {
        return (X)this.newProxy(new Class[]{interfaces});
    }
}

