/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.database.search;

import java.sql.ResultSet;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.database.PrimaryKeyFilter;
import org.dbunit.database.search.ForeignKeyRelationshipEdge;
import org.dbunit.database.search.ImportedAndExportedKeysSearchCallback;
import org.dbunit.dataset.filter.ITableFilter;
import org.dbunit.util.search.IEdge;
import org.dbunit.util.search.SearchException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportedAndExportedKeysSearchCallbackFilteredByPKs
extends ImportedAndExportedKeysSearchCallback {
    private static final Logger logger = LoggerFactory.getLogger(ImportedAndExportedKeysSearchCallbackFilteredByPKs.class);
    private final PrimaryKeyFilter pksFilter;

    public ImportedAndExportedKeysSearchCallbackFilteredByPKs(IDatabaseConnection connection, PrimaryKeyFilter.PkTableMap allowedPKs) {
        super(connection);
        this.pksFilter = new PrimaryKeyFilter(connection, allowedPKs, true);
    }

    public ITableFilter getFilter() {
        return this.pksFilter;
    }

    public void nodeAdded(Object node) throws SearchException {
        logger.debug("nodeAdded(node={}) - start", node);
        this.pksFilter.nodeAdded(node);
    }

    protected IEdge newEdge(ResultSet rs, int type, String from, String to, String fkColumn, String pkColumn) throws SearchException {
        if (logger.isDebugEnabled()) {
            logger.debug("newEdge(rs={}, type={}, from={}, to={}, fkColumn={}, pkColumn={}) - start", new Object[]{rs, String.valueOf(type), from, to, fkColumn, pkColumn});
        }
        ForeignKeyRelationshipEdge edge = ImportedAndExportedKeysSearchCallbackFilteredByPKs.createFKEdge(rs, type, from, to, fkColumn, pkColumn);
        this.pksFilter.edgeAdded(edge);
        return edge;
    }
}

