/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.simple;

import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Polygon;
import org.geotools.geometry.jts.CurvedGeometry;
import org.geotools.gml2.simple.GMLWriter;
import org.geotools.gml2.simple.GeometryEncoder;
import org.geotools.gml2.simple.QualifiedName;
import org.geotools.gml3.simple.LinearRingEncoder;
import org.geotools.gml3.simple.RingEncoder;
import org.geotools.xml.Encoder;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

class PolygonEncoder
extends GeometryEncoder<Polygon> {
    static final QualifiedName POLYGON = new QualifiedName("http://www.opengis.net/gml", "Polygon", "gml");
    static final QualifiedName EXTERIOR = new QualifiedName("http://www.opengis.net/gml", "exterior", "gml");
    static final QualifiedName INTERIOR = new QualifiedName("http://www.opengis.net/gml", "interior", "gml");
    QualifiedName polygon;
    QualifiedName exterior;
    QualifiedName interior;
    LinearRingEncoder lre;
    RingEncoder re;

    protected PolygonEncoder(Encoder encoder, String gmlPrefix, String gmlUri) {
        super(encoder);
        this.polygon = POLYGON.derive(gmlPrefix, gmlUri);
        this.exterior = EXTERIOR.derive(gmlPrefix, gmlUri);
        this.interior = INTERIOR.derive(gmlPrefix, gmlUri);
        this.lre = new LinearRingEncoder(encoder, gmlPrefix, gmlUri);
        this.re = new RingEncoder(encoder, gmlPrefix, gmlUri);
    }

    public void encode(Polygon geometry, AttributesImpl atts, GMLWriter handler) throws Exception {
        handler.startElement(this.polygon, (Attributes)atts);
        handler.startElement(this.exterior, null);
        this.encodeRing(geometry.getExteriorRing(), handler);
        handler.endElement(this.exterior);
        for (int i = 0; i < geometry.getNumInteriorRing(); ++i) {
            handler.startElement(this.interior, null);
            this.encodeRing(geometry.getInteriorRingN(i), handler);
            handler.endElement(this.interior);
        }
        handler.endElement(this.polygon);
    }

    private void encodeRing(LineString ring, GMLWriter handler) throws Exception {
        if (ring instanceof CurvedGeometry) {
            this.re.encode(ring, null, handler);
        } else {
            this.lre.encode(ring, null, handler);
        }
    }
}

