/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset;

import java.util.HashMap;
import java.util.Map;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplacementTable
implements ITable {
    private static final Logger logger = LoggerFactory.getLogger(ReplacementTable.class);
    private final ITable _table;
    private final Map _objectMap;
    private final Map _substringMap;
    private String _startDelim;
    private String _endDelim;
    private boolean _strictReplacement;

    public ReplacementTable(ITable table) {
        this(table, new HashMap(), new HashMap(), null, null);
    }

    public ReplacementTable(ITable table, Map objectMap, Map substringMap, String startDelimiter, String endDelimiter) {
        this._table = table;
        this._objectMap = objectMap;
        this._substringMap = substringMap;
        this._startDelim = startDelimiter;
        this._endDelim = endDelimiter;
    }

    public void setStrictReplacement(boolean strictReplacement) {
        if (logger.isDebugEnabled()) {
            logger.debug("setStrictReplacement(strictReplacement={}) - start", (Object)String.valueOf(strictReplacement));
        }
        this._strictReplacement = strictReplacement;
    }

    public void addReplacementObject(Object originalObject, Object replacementObject) {
        logger.debug("addReplacementObject(originalObject={}, replacementObject={}) - start", originalObject, replacementObject);
        this._objectMap.put(originalObject, replacementObject);
    }

    public void addReplacementSubstring(String originalSubstring, String replacementSubstring) {
        logger.debug("addReplacementSubstring(originalSubstring={}, replacementSubstring={}) - start", (Object)originalSubstring, (Object)replacementSubstring);
        if (originalSubstring == null || replacementSubstring == null) {
            throw new NullPointerException();
        }
        this._substringMap.put(originalSubstring, replacementSubstring);
    }

    public void setSubstringDelimiters(String startDelimiter, String endDelimiter) {
        logger.debug("setSubstringDelimiters(startDelimiter={}, endDelimiter={}) - start", (Object)startDelimiter, (Object)endDelimiter);
        if (startDelimiter == null || endDelimiter == null) {
            throw new NullPointerException();
        }
        this._startDelim = startDelimiter;
        this._endDelim = endDelimiter;
    }

    private void replaceAll(StringBuffer text, String source, String target) {
        int index = 0;
        while ((index = text.toString().indexOf(source, index)) != -1) {
            text.replace(index, index + source.length(), target);
            index += target.length();
        }
    }

    private String replaceStrings(String value, String lDelim, String rDelim) {
        StringBuffer buffer = new StringBuffer(value);
        for (Map.Entry entry : this._substringMap.entrySet()) {
            String original = (String)entry.getKey();
            String replacement = (String)entry.getValue();
            this.replaceAll(buffer, lDelim + original + rDelim, replacement);
        }
        return buffer == null ? value : buffer.toString();
    }

    private String replaceSubstrings(String value) {
        return this.replaceStrings(value, "", "");
    }

    private String replaceDelimitedSubstrings(String value) throws DataSetException {
        StringBuffer buffer = null;
        int startIndex = 0;
        int endIndex = 0;
        int lastEndIndex = 0;
        do {
            String substring;
            if ((startIndex = value.indexOf(this._startDelim, lastEndIndex)) == -1 || (endIndex = value.indexOf(this._endDelim, startIndex + this._startDelim.length())) == -1) continue;
            if (buffer == null) {
                buffer = new StringBuffer();
            }
            if (this._substringMap.containsKey(substring = value.substring(startIndex + this._startDelim.length(), endIndex))) {
                buffer.append(value.substring(lastEndIndex, startIndex));
                buffer.append(this._substringMap.get(substring));
            } else {
                if (this._strictReplacement) {
                    throw new DataSetException("Strict Replacement was set to true, but no replacement was found for substring '" + substring + "' in the value '" + value + "'");
                }
                logger.debug("Did not find a replacement map entry for substring={}. Leaving original value there.", (Object)substring);
                buffer.append(value.substring(lastEndIndex, endIndex + this._endDelim.length()));
            }
            lastEndIndex = endIndex + this._endDelim.length();
        } while (startIndex != -1 && endIndex != -1);
        if (buffer != null) {
            buffer.append(value.substring(lastEndIndex));
        }
        return buffer == null ? value : buffer.toString();
    }

    public ITableMetaData getTableMetaData() {
        return this._table.getTableMetaData();
    }

    public int getRowCount() {
        return this._table.getRowCount();
    }

    public Object getValue(int row, String column) throws DataSetException {
        Object value;
        if (logger.isDebugEnabled()) {
            logger.debug("getValue(row={}, columnName={}) - start", (Object)Integer.toString(row), (Object)column);
        }
        if (this._objectMap.containsKey(value = this._table.getValue(row, column))) {
            return this._objectMap.get(value);
        }
        if (this._substringMap.size() == 0 || !(value instanceof String)) {
            return value;
        }
        if (this._startDelim != null && this._endDelim != null) {
            return this.replaceDelimitedSubstrings((String)value);
        }
        return this.replaceSubstrings((String)value);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName()).append("[");
        sb.append("_strictReplacement=").append(this._strictReplacement);
        sb.append(", _table=").append(this._table);
        sb.append(", _objectMap=").append(this._objectMap);
        sb.append(", _substringMap=").append(this._substringMap);
        sb.append(", _startDelim=").append(this._startDelim);
        sb.append(", _endDelim=").append(this._endDelim);
        sb.append("]");
        return sb.toString();
    }
}

