/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.datatype;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.datatype.AbstractDataType;
import org.dbunit.dataset.datatype.TypeCastException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntegerDataType
extends AbstractDataType {
    private static final Logger logger = LoggerFactory.getLogger(IntegerDataType.class);

    IntegerDataType(String name, int sqlType) {
        super(name, sqlType, Integer.class, true);
    }

    public Object typeCast(Object value) throws TypeCastException {
        String stringValue;
        logger.debug("typeCast(value={}) - start", value);
        if (value == null || value == ITable.NO_VALUE) {
            return null;
        }
        if (value instanceof Number) {
            return new Integer(((Number)value).intValue());
        }
        if (value instanceof String) {
            String string = (String)value;
            if ("false".equalsIgnoreCase(string)) {
                return new Integer(0);
            }
            if ("true".equalsIgnoreCase(string)) {
                return new Integer(1);
            }
        }
        if ((stringValue = value.toString().trim()).length() <= 0) {
            return null;
        }
        try {
            return this.typeCast(new BigDecimal(stringValue));
        }
        catch (NumberFormatException e) {
            throw new TypeCastException(value, this, e);
        }
    }

    public Object getSqlValue(int column, ResultSet resultSet) throws SQLException, TypeCastException {
        if (logger.isDebugEnabled()) {
            logger.debug("getSqlValue(column={}, resultSet={}) - start", (Object)new Integer(column), (Object)resultSet);
        }
        int value = resultSet.getInt(column);
        if (resultSet.wasNull()) {
            return null;
        }
        return new Integer(value);
    }

    public void setSqlValue(Object value, int column, PreparedStatement statement) throws SQLException, TypeCastException {
        if (logger.isDebugEnabled()) {
            logger.debug("setSqlValue(value={}, column={}, statement={}) - start", new Object[]{value, new Integer(column), statement});
        }
        statement.setInt(column, (Integer)this.typeCast(value));
    }
}

