/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.postgis;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryComponentFilter;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.geotools.data.jdbc.FilterToSQL;
import org.geotools.data.postgis.PostgisFilterToSQL;
import org.geotools.data.postgis.PostgisPSFilterToSql;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.FilterCapabilities;
import org.geotools.filter.function.FilterFunction_strConcat;
import org.geotools.filter.function.FilterFunction_strEndsWith;
import org.geotools.filter.function.FilterFunction_strEqualsIgnoreCase;
import org.geotools.filter.function.FilterFunction_strIndexOf;
import org.geotools.filter.function.FilterFunction_strLength;
import org.geotools.filter.function.FilterFunction_strReplace;
import org.geotools.filter.function.FilterFunction_strStartsWith;
import org.geotools.filter.function.FilterFunction_strSubstring;
import org.geotools.filter.function.FilterFunction_strSubstringStart;
import org.geotools.filter.function.FilterFunction_strToLowerCase;
import org.geotools.filter.function.FilterFunction_strToUpperCase;
import org.geotools.filter.function.FilterFunction_strTrim;
import org.geotools.filter.function.FilterFunction_strTrim2;
import org.geotools.filter.function.math.FilterFunction_abs;
import org.geotools.filter.function.math.FilterFunction_abs_2;
import org.geotools.filter.function.math.FilterFunction_abs_3;
import org.geotools.filter.function.math.FilterFunction_abs_4;
import org.geotools.filter.function.math.FilterFunction_ceil;
import org.geotools.filter.function.math.FilterFunction_floor;
import org.geotools.geometry.jts.JTS;
import org.geotools.jdbc.SQLDialect;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.BBOX3D;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.spatial.BinarySpatialOperator;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.DistanceBufferOperator;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;
import org.opengis.filter.temporal.After;
import org.opengis.filter.temporal.Before;
import org.opengis.filter.temporal.Begins;
import org.opengis.filter.temporal.BegunBy;
import org.opengis.filter.temporal.During;
import org.opengis.filter.temporal.EndedBy;
import org.opengis.filter.temporal.Ends;
import org.opengis.filter.temporal.TEquals;
import org.opengis.filter.temporal.TOverlaps;
import org.opengis.geometry.BoundingBox3D;

class FilterToSqlHelper {
    protected static final String IO_ERROR = "io problem writing filter";
    private static final Map<String, Double> UNITS_MAP = new HashMap<String, Double>(){
        {
            this.put("kilometers", 1000.0);
            this.put("kilometer", 1000.0);
            this.put("mm", 0.001);
            this.put("millimeter", 0.001);
            this.put("mi", 1609.344);
            this.put("miles", 1609.344);
            this.put("NM", 1852.0);
            this.put("feet", 0.3048);
            this.put("ft", 0.3048);
            this.put("in", 0.0254);
        }
    };
    private static final Envelope WORLD = new Envelope(-180.0, 180.0, -90.0, 90.0);
    FilterToSQL delegate;
    Writer out;
    boolean looseBBOXEnabled;
    boolean encodeBBOXFilterAsEnvelope;

    public FilterToSqlHelper(FilterToSQL delegate) {
        this.delegate = delegate;
    }

    public static FilterCapabilities createFilterCapabilities(boolean encodeFunctions) {
        FilterCapabilities caps = new FilterCapabilities();
        caps.addAll(SQLDialect.BASE_DBMS_CAPABILITIES);
        caps.addType(BBOX.class);
        caps.addType(BBOX3D.class);
        caps.addType(Contains.class);
        caps.addType(Crosses.class);
        caps.addType(Disjoint.class);
        caps.addType(Equals.class);
        caps.addType(Intersects.class);
        caps.addType(Overlaps.class);
        caps.addType(Touches.class);
        caps.addType(Within.class);
        caps.addType(DWithin.class);
        caps.addType(Beyond.class);
        caps.addType(After.class);
        caps.addType(Before.class);
        caps.addType(Begins.class);
        caps.addType(BegunBy.class);
        caps.addType(During.class);
        caps.addType(TOverlaps.class);
        caps.addType(Ends.class);
        caps.addType(EndedBy.class);
        caps.addType(TEquals.class);
        if (encodeFunctions) {
            caps.addType(FilterFunction_strConcat.class);
            caps.addType(FilterFunction_strEndsWith.class);
            caps.addType(FilterFunction_strStartsWith.class);
            caps.addType(FilterFunction_strEqualsIgnoreCase.class);
            caps.addType(FilterFunction_strIndexOf.class);
            caps.addType(FilterFunction_strLength.class);
            caps.addType(FilterFunction_strToLowerCase.class);
            caps.addType(FilterFunction_strToUpperCase.class);
            caps.addType(FilterFunction_strReplace.class);
            caps.addType(FilterFunction_strSubstring.class);
            caps.addType(FilterFunction_strSubstringStart.class);
            caps.addType(FilterFunction_strTrim.class);
            caps.addType(FilterFunction_strTrim2.class);
            caps.addType(FilterFunction_abs.class);
            caps.addType(FilterFunction_abs_2.class);
            caps.addType(FilterFunction_abs_3.class);
            caps.addType(FilterFunction_abs_4.class);
            caps.addType(FilterFunction_ceil.class);
            caps.addType(FilterFunction_floor.class);
        }
        return caps;
    }

    protected Object visitBinarySpatialOperator(BinarySpatialOperator filter, PropertyName property, Literal geometry, boolean swapped, Object extraData) {
        try {
            if (filter instanceof DistanceBufferOperator) {
                this.visitDistanceSpatialOperator((DistanceBufferOperator)filter, property, geometry, swapped, extraData);
            } else {
                this.visitComparisonSpatialOperator(filter, property, geometry, swapped, extraData);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(IO_ERROR, e);
        }
        return extraData;
    }

    protected Object visitBinarySpatialOperator(BinarySpatialOperator filter, Expression e1, Expression e2, Object extraData) {
        try {
            this.visitBinarySpatialOperator(filter, e1, e2, false, extraData);
        }
        catch (IOException e) {
            throw new RuntimeException(IO_ERROR, e);
        }
        return extraData;
    }

    void visitDistanceSpatialOperator(DistanceBufferOperator filter, PropertyName property, Literal geometry, boolean swapped, Object extraData) throws IOException {
        if (filter instanceof DWithin && !swapped || filter instanceof Beyond && swapped) {
            this.out.write("ST_DWithin(");
            property.accept((ExpressionVisitor)this.delegate, extraData);
            this.out.write(",");
            geometry.accept((ExpressionVisitor)this.delegate, extraData);
            this.out.write(",");
            this.out.write(this.toMeters(filter.getDistance(), filter.getDistanceUnits()));
            this.out.write(")");
        }
        if (filter instanceof DWithin && swapped || filter instanceof Beyond && !swapped) {
            this.out.write("ST_Distance(");
            property.accept((ExpressionVisitor)this.delegate, extraData);
            this.out.write(",");
            geometry.accept((ExpressionVisitor)this.delegate, extraData);
            this.out.write(") > ");
            this.out.write(Double.toString(filter.getDistance()));
        }
    }

    private String toMeters(double distance, String unit) {
        Double conversion;
        if (this.isCurrentGeography() && (conversion = UNITS_MAP.get(unit)) != null) {
            return String.valueOf(distance * conversion);
        }
        return String.valueOf(distance);
    }

    void visitComparisonSpatialOperator(BinarySpatialOperator filter, PropertyName property, Literal geometry, boolean swapped, Object extraData) throws IOException {
        if (this.isCurrentGeography()) {
            if (this.isWorld(geometry = this.clipToWorld(geometry))) {
                this.out.write(" TRUE ");
                return;
            }
            if (this.isEmpty(geometry)) {
                if (!(filter instanceof Disjoint)) {
                    this.out.write(" FALSE ");
                } else {
                    this.out.write(" TRUE ");
                }
                return;
            }
        }
        if (filter instanceof BBOX3D) {
            property.accept((ExpressionVisitor)this.delegate, extraData);
            this.out.write(" &&& ");
            BBOX3D bbox = (BBOX3D)filter;
            BoundingBox3D bounds = bbox.getBounds();
            this.out.write("ST_Makeline(ST_MakePoint(");
            this.out.write(bounds.getMinX() + "," + bounds.getMinY() + "," + bounds.getMinZ());
            this.out.write("), ST_MakePoint(");
            this.out.write(bounds.getMaxX() + "," + bounds.getMaxY() + "," + bounds.getMaxZ());
            this.out.write("))");
        } else {
            if (!(filter instanceof Disjoint)) {
                if (this.encodeBBOXFilterAsEnvelope && !this.isCurrentGeography()) {
                    this.out.write("ST_envelope(");
                }
                property.accept((ExpressionVisitor)this.delegate, extraData);
                if (this.encodeBBOXFilterAsEnvelope && !this.isCurrentGeography()) {
                    this.out.write(")");
                }
                this.out.write(" && ");
                geometry.accept((ExpressionVisitor)this.delegate, extraData);
                if (filter instanceof BBOX && this.looseBBOXEnabled) {
                    return;
                }
                this.out.write(" AND ");
            }
            this.visitBinarySpatialOperator(filter, (Expression)property, (Expression)geometry, swapped, extraData);
        }
    }

    void visitBinarySpatialOperator(BinarySpatialOperator filter, Expression e1, Expression e2, boolean swapped, Object extraData) throws IOException {
        String closingParenthesis = ")";
        if (filter instanceof Equals) {
            this.out.write("ST_Equals");
        } else if (filter instanceof Disjoint) {
            this.out.write("NOT (ST_Intersects");
            closingParenthesis = closingParenthesis + ")";
        } else if (filter instanceof Intersects || filter instanceof BBOX) {
            this.out.write("ST_Intersects");
        } else if (filter instanceof Crosses) {
            this.out.write("ST_Crosses");
        } else if (filter instanceof Within) {
            if (swapped) {
                this.out.write("ST_Contains");
            } else {
                this.out.write("ST_Within");
            }
        } else if (filter instanceof Contains) {
            if (swapped) {
                this.out.write("ST_Within");
            } else {
                this.out.write("ST_Contains");
            }
        } else if (filter instanceof Overlaps) {
            this.out.write("ST_Overlaps");
        } else if (filter instanceof Touches) {
            this.out.write("ST_Touches");
        } else {
            throw new RuntimeException("Unsupported filter type " + filter.getClass());
        }
        this.out.write("(");
        e1.accept((ExpressionVisitor)this.delegate, extraData);
        this.out.write(", ");
        e2.accept((ExpressionVisitor)this.delegate, extraData);
        this.out.write(closingParenthesis);
    }

    boolean isCurrentGeography() {
        GeometryDescriptor geom = null;
        if (this.delegate instanceof PostgisPSFilterToSql) {
            geom = ((PostgisPSFilterToSql)this.delegate).getCurrentGeometry();
        } else if (this.delegate instanceof PostgisFilterToSQL) {
            geom = ((PostgisFilterToSQL)this.delegate).getCurrentGeometry();
        }
        return geom != null && "geography".equals(geom.getUserData().get("org.geotools.jdbc.nativeTypeName"));
    }

    private Literal clipToWorld(Literal geometry) {
        Geometry g;
        if (geometry != null && (g = (Geometry)geometry.evaluate(null, Geometry.class)) != null) {
            Envelope env = g.getEnvelopeInternal();
            if (!WORLD.contains(env)) {
                g = this.sanitizePolygons(g.intersection((Geometry)JTS.toGeometry(WORLD)));
            }
            if (Math.sqrt((env = g.getEnvelopeInternal()).getWidth() * env.getWidth() + env.getHeight() * env.getHeight()) >= 180.0) {
                ArrayList<Polygon> polygons = new ArrayList<Polygon>();
                for (double lon = Math.floor(env.getMinX()); lon < env.getMaxX(); lon += 90.0) {
                    for (double lat = Math.floor(env.getMinY()); lat < env.getMaxY(); lat += 90.0) {
                        Polygon quadrant = JTS.toGeometry(new Envelope(lon, lon + 90.0, lat, lat + 90.0));
                        Geometry cut = this.sanitizePolygons(g.intersection((Geometry)quadrant));
                        if (cut.isEmpty()) continue;
                        if (cut instanceof Polygon) {
                            polygons.add((Polygon)cut);
                            continue;
                        }
                        for (int i = 0; i < cut.getNumGeometries(); ++i) {
                            polygons.add((Polygon)cut.getGeometryN(i));
                        }
                    }
                }
                g = this.toPolygon(g.getFactory(), polygons);
            }
            geometry = CommonFactoryFinder.getFilterFactory(null).literal((Object)g);
        }
        return geometry;
    }

    private Geometry sanitizePolygons(Geometry geometry) {
        if (geometry == null || geometry instanceof Polygon || geometry instanceof MultiPolygon) {
            return geometry;
        }
        final ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        geometry.apply(new GeometryComponentFilter(){

            public void filter(Geometry geom) {
                if (geom instanceof Polygon) {
                    polygons.add((Polygon)geom);
                }
            }
        });
        return this.toPolygon(geometry.getFactory(), polygons);
    }

    private Geometry toPolygon(GeometryFactory gf, List<Polygon> polygons) {
        if (polygons.size() == 0) {
            return gf.createGeometryCollection(null);
        }
        if (polygons.size() == 1) {
            return (Geometry)polygons.get(0);
        }
        return gf.createMultiPolygon(polygons.toArray(new Polygon[polygons.size()]));
    }

    private boolean isWorld(Literal geometry) {
        Geometry g;
        if (geometry != null && (g = (Geometry)geometry.evaluate(null, Geometry.class)) != null) {
            return JTS.toGeometry(WORLD).equalsTopo(g.union());
        }
        return false;
    }

    private boolean isEmpty(Literal geometry) {
        if (geometry != null) {
            Geometry g = (Geometry)geometry.evaluate(null, Geometry.class);
            return g == null || g.isEmpty();
        }
        return false;
    }

    public String getFunctionName(Function function) {
        if (function instanceof FilterFunction_strLength) {
            return "char_length";
        }
        if (function instanceof FilterFunction_strToLowerCase) {
            return "lower";
        }
        if (function instanceof FilterFunction_strToUpperCase) {
            return "upper";
        }
        if (function instanceof FilterFunction_abs || function instanceof FilterFunction_abs_2 || function instanceof FilterFunction_abs_3 || function instanceof FilterFunction_abs_4) {
            return "abs";
        }
        return function.getName();
    }

    public boolean visitFunction(Function function, Object extraData) throws IOException {
        if (function instanceof FilterFunction_strConcat) {
            Expression s1 = this.getParameter(function, 0, true);
            Expression s2 = this.getParameter(function, 1, true);
            this.out.write("(");
            s1.accept((ExpressionVisitor)this.delegate, String.class);
            this.out.write(" || ");
            s2.accept((ExpressionVisitor)this.delegate, String.class);
            this.out.write(")");
        } else if (function instanceof FilterFunction_strEndsWith) {
            Expression str = this.getParameter(function, 0, true);
            Expression end = this.getParameter(function, 1, true);
            this.out.write("(");
            str.accept((ExpressionVisitor)this.delegate, String.class);
            this.out.write(" LIKE ");
            if (end instanceof Literal) {
                this.out.write("'%" + (String)end.evaluate(null, String.class) + "'");
            } else {
                this.out.write("('%' || ");
                end.accept((ExpressionVisitor)this.delegate, String.class);
                this.out.write(")");
            }
            this.out.write(")");
        } else if (function instanceof FilterFunction_strStartsWith) {
            Expression str = this.getParameter(function, 0, true);
            Expression start = this.getParameter(function, 1, true);
            this.out.write("(");
            str.accept((ExpressionVisitor)this.delegate, String.class);
            this.out.write(" LIKE ");
            if (start instanceof Literal) {
                this.out.write("'" + (String)start.evaluate(null, String.class) + "%'");
            } else {
                this.out.write("(");
                start.accept((ExpressionVisitor)this.delegate, String.class);
                this.out.write(" || '%')");
            }
            this.out.write(")");
        } else if (function instanceof FilterFunction_strEqualsIgnoreCase) {
            Expression first = this.getParameter(function, 0, true);
            Expression second = this.getParameter(function, 1, true);
            this.out.write("(lower(");
            first.accept((ExpressionVisitor)this.delegate, String.class);
            this.out.write(") = lower(");
            second.accept((ExpressionVisitor)this.delegate, String.class);
            this.out.write("::text))");
        } else if (function instanceof FilterFunction_strIndexOf) {
            Expression first = this.getParameter(function, 0, true);
            Expression second = this.getParameter(function, 1, true);
            this.out.write("(strpos(");
            first.accept((ExpressionVisitor)this.delegate, String.class);
            this.out.write(", ");
            second.accept((ExpressionVisitor)this.delegate, String.class);
            this.out.write(") - 1)");
        } else if (function instanceof FilterFunction_strSubstring) {
            Expression string = this.getParameter(function, 0, true);
            Expression start = this.getParameter(function, 1, true);
            Expression end = this.getParameter(function, 2, true);
            this.out.write("substr(");
            string.accept((ExpressionVisitor)this.delegate, String.class);
            this.out.write(", ");
            start.accept((ExpressionVisitor)this.delegate, Integer.class);
            this.out.write(" + 1, (");
            end.accept((ExpressionVisitor)this.delegate, Integer.class);
            this.out.write(" - ");
            start.accept((ExpressionVisitor)this.delegate, Integer.class);
            this.out.write("))");
        } else if (function instanceof FilterFunction_strSubstringStart) {
            Expression string = this.getParameter(function, 0, true);
            Expression start = this.getParameter(function, 1, true);
            this.out.write("substr(");
            string.accept((ExpressionVisitor)this.delegate, String.class);
            this.out.write(", ");
            start.accept((ExpressionVisitor)this.delegate, Integer.class);
            this.out.write(" + 1)");
        } else if (function instanceof FilterFunction_strTrim) {
            Expression string = this.getParameter(function, 0, true);
            this.out.write("trim(both ' ' from ");
            string.accept((ExpressionVisitor)this.delegate, String.class);
            this.out.write(")");
        } else {
            return false;
        }
        return true;
    }

    Expression getParameter(Function function, int idx, boolean mandatory) {
        List params = function.getParameters();
        if ((params == null || params.size() <= idx) && mandatory) {
            throw new IllegalArgumentException("Missing parameter number " + (idx + 1) + "for function " + function.getName() + ", cannot encode in SQL");
        }
        return (Expression)params.get(idx);
    }

    public String cast(String property, Class target) {
        if (String.class.equals((Object)target)) {
            return property + "::text";
        }
        if (Short.class.equals((Object)target) || Byte.class.equals((Object)target)) {
            return property + "::smallint";
        }
        if (Integer.class.equals((Object)target)) {
            return property + "::integer";
        }
        if (Long.class.equals((Object)target)) {
            return property + "::bigint";
        }
        if (Float.class.equals((Object)target)) {
            return property + "::real";
        }
        if (Double.class.equals((Object)target)) {
            return property + "::float8";
        }
        if (BigInteger.class.equals((Object)target)) {
            return property + "::numeric";
        }
        if (BigDecimal.class.equals((Object)target)) {
            return property + "::decimal";
        }
        if (Double.class.equals((Object)target)) {
            return property + "::float8";
        }
        if (Time.class.isAssignableFrom(target)) {
            return property + "::time";
        }
        if (Timestamp.class.isAssignableFrom(target)) {
            return property + "::timestamp";
        }
        if (Date.class.isAssignableFrom(target)) {
            return property + "::date";
        }
        if (java.util.Date.class.isAssignableFrom(target)) {
            return property + "::timesamp";
        }
        return property;
    }
}

