/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.xml;

import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.DefaultTableMetaData;
import org.dbunit.dataset.datatype.DataType;
import org.dbunit.dataset.stream.DefaultConsumer;
import org.dbunit.dataset.stream.IDataSetConsumer;
import org.dbunit.dataset.stream.IDataSetProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;

public class FlatDtdProducer
implements IDataSetProducer,
EntityResolver,
DeclHandler,
LexicalHandler {
    public static final String REQUIRED = "#REQUIRED";
    public static final String IMPLIED = "#IMPLIED";
    public static final String ANY = "ANY";
    private static final Logger logger = LoggerFactory.getLogger(FlatDtdProducer.class);
    private static final IDataSetConsumer EMPTY_CONSUMER = new DefaultConsumer();
    private static final String XML_CONTENT = "<?xml version=\"1.0\"?><!DOCTYPE dataset SYSTEM \"urn:/dummy.dtd\"><dataset/>";
    private static final String DECL_HANDLER_PROPERTY_NAME = "http://xml.org/sax/properties/declaration-handler";
    private static final String LEXICAL_HANDLER_PROPERTY_NAME = "http://xml.org/sax/properties/lexical-handler";
    private InputSource _inputSource;
    private IDataSetConsumer _consumer = EMPTY_CONSUMER;
    private String _rootName;
    private String _rootModel;
    private final Map _columnListMap = new HashMap();

    public FlatDtdProducer() {
    }

    public FlatDtdProducer(InputSource inputSource) {
        this._inputSource = inputSource;
    }

    public static void setDeclHandler(XMLReader xmlReader, DeclHandler handler) throws SAXNotRecognizedException, SAXNotSupportedException {
        logger.debug("setDeclHandler(xmlReader={}, handler={}) - start", (Object)xmlReader, (Object)handler);
        xmlReader.setProperty(DECL_HANDLER_PROPERTY_NAME, handler);
    }

    public static void setLexicalHandler(XMLReader xmlReader, LexicalHandler handler) throws SAXNotRecognizedException, SAXNotSupportedException {
        logger.debug("setLexicalHandler(xmlReader={}, handler={}) - start", (Object)xmlReader, (Object)handler);
        xmlReader.setProperty(LEXICAL_HANDLER_PROPERTY_NAME, handler);
    }

    private List createColumnList() {
        return new LinkedList();
    }

    public void setConsumer(IDataSetConsumer consumer) throws DataSetException {
        this._consumer = consumer;
    }

    public void produce() throws DataSetException {
        logger.debug("produce() - start");
        try {
            SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
            XMLReader xmlReader = saxParser.getXMLReader();
            FlatDtdProducer.setDeclHandler(xmlReader, this);
            FlatDtdProducer.setLexicalHandler(xmlReader, this);
            xmlReader.setEntityResolver(this);
            xmlReader.parse(new InputSource(new StringReader(XML_CONTENT)));
        }
        catch (ParserConfigurationException e) {
            throw new DataSetException(e);
        }
        catch (SAXException e) {
            Exception exception;
            Exception exception2 = exception = e.getException() == null ? e : e.getException();
            if (exception instanceof DataSetException) {
                throw (DataSetException)exception;
            }
            throw new DataSetException(exception);
        }
        catch (IOException e) {
            throw new DataSetException(e);
        }
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        return this._inputSource;
    }

    public void elementDecl(String name, String model) throws SAXException {
        logger.debug("elementDecl(name={}, model={}) - start", (Object)name, (Object)model);
        if (name.equals(this._rootName)) {
            this._rootModel = model;
        } else if (!this._columnListMap.containsKey(name)) {
            this._columnListMap.put(name, this.createColumnList());
        }
    }

    public void attributeDecl(String elementName, String attributeName, String type, String mode, String value) throws SAXException {
        if (logger.isDebugEnabled()) {
            logger.debug("attributeDecl(elementName={}, attributeName={}, type={}, mode={}, value={}) - start", new Object[]{elementName, attributeName, type, mode, value});
        }
        Column.Nullable nullable = REQUIRED.equals(mode) ? Column.NO_NULLS : Column.NULLABLE;
        Column column = new Column(attributeName, DataType.UNKNOWN, nullable);
        if (!this._columnListMap.containsKey(elementName)) {
            this._columnListMap.put(elementName, this.createColumnList());
        }
        List columnList = (List)this._columnListMap.get(elementName);
        columnList.add(column);
    }

    public void internalEntityDecl(String name, String value) throws SAXException {
    }

    public void externalEntityDecl(String name, String publicId, String systemId) throws SAXException {
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        if (logger.isDebugEnabled()) {
            logger.debug("startDTD(name={}, publicId={}, systemId={}) - start", new Object[]{name, publicId, systemId});
        }
        try {
            this._rootName = name;
            this._consumer.startDataSet();
        }
        catch (DataSetException e) {
            throw new SAXException(e);
        }
    }

    public void endDTD() throws SAXException {
        logger.debug("endDTD() - start");
        try {
            if (this._rootModel == null) {
                logger.info("The rootModel is null. Cannot add tables.");
            } else if (ANY.equalsIgnoreCase(this._rootModel)) {
                for (String tableName : this._columnListMap.keySet()) {
                    this.addTable(tableName);
                }
            } else {
                String rootModel = this._rootModel.substring(1, this._rootModel.length() - 1);
                String delim = rootModel.indexOf(",") != -1 ? "," : "|";
                StringTokenizer tokenizer = new StringTokenizer(rootModel, delim);
                while (tokenizer.hasMoreTokens()) {
                    String tableName = tokenizer.nextToken();
                    tableName = this.cleanupTableName(tableName);
                    this.addTable(tableName);
                }
            }
            this._consumer.endDataSet();
        }
        catch (DataSetException e) {
            throw new SAXException(e);
        }
    }

    private void addTable(String tableName) throws DataSetException {
        Column[] columns = this.getColumns(tableName);
        this._consumer.startTable(new DefaultTableMetaData(tableName, columns));
        this._consumer.endTable();
    }

    private Column[] getColumns(String tableName) throws DataSetException {
        List columnList = (List)this._columnListMap.get(tableName);
        if (columnList == null) {
            throw new DataSetException("ELEMENT/ATTRIBUTE declaration for '" + tableName + "' is missing. " + "Every table must have an element describing the table.");
        }
        Column[] columns = columnList.toArray(new Column[0]);
        return columns;
    }

    protected String cleanupTableName(String tableName) {
        String cleaned = tableName;
        while (cleaned.startsWith("(")) {
            cleaned = cleaned.substring(1);
        }
        while (cleaned.endsWith(")") || cleaned.endsWith("*") || cleaned.endsWith("?") || cleaned.endsWith("+")) {
            cleaned = cleaned.substring(0, cleaned.length() - 1);
        }
        return cleaned;
    }

    public void startEntity(String name) throws SAXException {
    }

    public void endEntity(String name) throws SAXException {
    }

    public void startCDATA() throws SAXException {
    }

    public void endCDATA() throws SAXException {
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
    }
}

