/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.geotools.data.Diff;
import org.geotools.data.FeatureReader;
import org.geotools.data.store.ContentState;
import org.geotools.data.wfs.internal.Loggers;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.geometry.BoundingBox;

public class WFSDiff
extends Diff {
    private Set<String> batchModified = new HashSet<String>();
    private List<BatchUpdate> batchCommands = new ArrayList<BatchUpdate>();

    public synchronized void clear() {
        this.batchModified.clear();
        this.batchCommands.clear();
        super.clear();
    }

    public List<BatchUpdate> getBatchUpdates() {
        return this.batchCommands;
    }

    public Set<String> getBatchModified() {
        return this.batchModified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modify(String fid, SimpleFeature f) {
        Set<String> set = this.batchModified;
        synchronized (set) {
            boolean removed = this.batchModified.remove(fid);
            if (removed) {
                Loggers.MODULE.finer("Removing " + fid + " from list of batch modified features as it's being modified directly");
            }
        }
        super.modify(fid, f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReferencedEnvelope batchModify(Name[] properties, Object[] values, Filter filter, FeatureReader<SimpleFeatureType, SimpleFeature> oldFeatures, ContentState contentState) throws IOException {
        ReferencedEnvelope bounds = new ReferencedEnvelope(contentState.getFeatureType().getCoordinateReferenceSystem());
        Set<String> set = this.batchModified;
        synchronized (set) {
            while (oldFeatures.hasNext()) {
                SimpleFeature old = (SimpleFeature)oldFeatures.next();
                BoundingBox fbounds = old.getBounds();
                if (fbounds != null) {
                    bounds.expandToInclude((Envelope)new ReferencedEnvelope(fbounds));
                }
                for (int i = 0; i < properties.length; ++i) {
                    Name propName = properties[i];
                    Object newValue = values[i];
                    old.setAttribute(propName, newValue);
                    if (!(newValue instanceof Geometry)) continue;
                    Envelope envelope = ((Geometry)newValue).getEnvelopeInternal();
                    bounds.expandToInclude(envelope);
                }
                String fid = old.getID();
                super.modify(fid, old);
                this.batchModified.add(fid);
            }
            BatchUpdate batch = new BatchUpdate(properties, values, filter);
            this.batchCommands.add(batch);
        }
        return bounds;
    }

    public static class BatchUpdate {
        final Name[] properties;
        final Object[] values;
        final Filter filter;

        public BatchUpdate(Name[] properties, Object[] values, Filter filter) {
            this.properties = properties;
            this.values = values;
            this.filter = filter;
        }
    }
}

