/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.opengis.wfs20.ListStoredQueriesResponseType;
import org.apache.commons.io.IOUtils;
import org.geotools.data.DataSourceException;
import org.geotools.data.ows.HTTPResponse;
import org.geotools.data.wfs.internal.AbstractWFSStrategy;
import org.geotools.data.wfs.internal.Loggers;
import org.geotools.data.wfs.internal.WFSRequest;
import org.geotools.data.wfs.internal.WFSResponse;
import org.geotools.ows.ServiceException;
import org.geotools.xml.Configuration;
import org.geotools.xml.DOMParser;
import org.w3c.dom.Document;

public class ListStoredQueriesResponse
extends WFSResponse {
    private ListStoredQueriesResponseType listStoredQueriesResponse;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListStoredQueriesResponse(WFSRequest originatingRequest, HTTPResponse response) throws IOException, ServiceException {
        super(originatingRequest, response);
        Loggers.MODULE.finer("Parsing ListStoredQueries response");
        try {
            Document rawDocument;
            ByteArrayOutputStream buff = new ByteArrayOutputStream();
            try (InputStream inputStream = response.getResponseStream();){
                IOUtils.copy((InputStream)inputStream, (OutputStream)buff);
            }
            byte[] rawResponse = buff.toByteArray();
            if (Loggers.RESPONSES.isLoggable(Level.FINE)) {
                Loggers.RESPONSES.fine("Full ListStoredQueries response: " + new String(rawResponse));
            }
            try {
                DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
                builderFactory.setNamespaceAware(true);
                builderFactory.setValidating(false);
                DocumentBuilder documentBuilder = builderFactory.newDocumentBuilder();
                rawDocument = documentBuilder.parse(new ByteArrayInputStream(rawResponse));
            }
            catch (Exception e) {
                throw new IOException("Error parsing capabilities document: " + e.getMessage(), e);
            }
            this.listStoredQueriesResponse = this.parseStoredQueries(rawDocument, AbstractWFSStrategy.WFS_2_0_CONFIGURATION);
            if (null == this.listStoredQueriesResponse) {
                throw new IllegalStateException("Unable to parse ListStoredQueries document");
            }
        }
        finally {
            response.dispose();
        }
    }

    private ListStoredQueriesResponseType parseStoredQueries(Document document, Configuration wfsConfig) throws DataSourceException {
        Object parsed;
        DOMParser parser = new DOMParser(wfsConfig, document);
        try {
            parsed = parser.parse();
        }
        catch (Exception e) {
            throw new DataSourceException("Exception parsing ListStoredQueriesResponse", (Throwable)e);
        }
        return (ListStoredQueriesResponseType)parsed;
    }

    public ListStoredQueriesResponseType getListStoredQueriesResponse() {
        return this.listStoredQueriesResponse;
    }
}

