/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.internal.parsers;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.opengis.ows10.ExceptionReportType;
import net.opengis.ows10.ExceptionType;
import org.eclipse.emf.common.util.EList;
import org.geotools.data.ows.HTTPResponse;
import org.geotools.data.wfs.internal.GetFeatureParser;
import org.geotools.data.wfs.internal.GetFeatureRequest;
import org.geotools.data.wfs.internal.GetFeatureResponse;
import org.geotools.data.wfs.internal.Loggers;
import org.geotools.data.wfs.internal.WFSException;
import org.geotools.data.wfs.internal.WFSOperationType;
import org.geotools.data.wfs.internal.WFSRequest;
import org.geotools.data.wfs.internal.WFSResponse;
import org.geotools.data.wfs.internal.WFSResponseFactory;
import org.geotools.ows.ServiceException;
import org.geotools.xml.Parser;
import org.xml.sax.EntityResolver;

public abstract class AbstractGetFeatureResponseParserFactory
implements WFSResponseFactory {
    private static final Logger LOGGER = Loggers.MODULE;

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public boolean canProcess(WFSRequest request, String contentType) {
        if (!WFSOperationType.GET_FEATURE.equals((Object)request.getOperation())) {
            return false;
        }
        if (!this.getSupportedVersions().contains(request.getStrategy().getVersion())) {
            return false;
        }
        boolean matches = this.getSupportedOutputFormats().contains(contentType);
        if (!matches) {
            for (String supported : this.getSupportedOutputFormats()) {
                if (!supported.startsWith(contentType) && !contentType.startsWith(supported)) continue;
                matches = true;
                break;
            }
        }
        return matches;
    }

    @Override
    public WFSResponse createResponse(WFSRequest request, HTTPResponse response) throws IOException {
        int r;
        int buffSize = LOGGER.isLoggable(Level.FINER) ? 4096 : 512;
        PushbackInputStream pushbackIn = new PushbackInputStream(response.getResponseStream(), buffSize);
        byte[] buff = new byte[buffSize];
        int readCount = 0;
        while ((r = pushbackIn.read(buff, readCount, buffSize - readCount)) != -1 && (readCount += r) != buffSize) {
        }
        String charset = response.getResponseHeader("Charset");
        try {
            Charset.forName(charset);
        }
        catch (Exception e) {
            charset = "UTF-8";
        }
        StringBuilder head = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(buff), charset));){
            String line;
            while ((line = reader.readLine()) != null) {
                head.append(line).append('\n');
            }
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("Response head:\n" + head);
        }
        pushbackIn.unread(buff, 0, readCount);
        if (head.indexOf("FeatureCollection") > 0) {
            GetFeatureParser parser = this.parser((GetFeatureRequest)request, pushbackIn);
            try {
                return new GetFeatureResponse(request, response, parser);
            }
            catch (ServiceException e) {
                throw new IOException(e);
            }
        }
        if (head.indexOf("ExceptionReport") > 0) {
            throw this.parseException(request, pushbackIn);
        }
        throw new IllegalStateException("Unkown server response: " + head);
    }

    public WFSException parseException(WFSRequest originatingRequest, InputStream inputStream) throws WFSException {
        Object parsed;
        Parser parser = new Parser(originatingRequest.getStrategy().getWfsConfiguration());
        EntityResolver resolver = originatingRequest.getStrategy().getConfig().getEntityResolver();
        if (resolver != null) {
            parser.setEntityResolver(resolver);
        }
        try {
            parsed = parser.parse(inputStream);
            if (!(parsed instanceof ExceptionReportType) && !(parsed instanceof net.opengis.ows11.ExceptionReportType)) {
                throw new IOException("Unrecognized server error");
            }
        }
        catch (Exception e) {
            return new WFSException("Exception parsing server exception report", e);
        }
        if (parsed instanceof ExceptionReportType) {
            ExceptionReportType report = (ExceptionReportType)parsed;
            EList exceptions = report.getException();
            StringBuilder msg = new StringBuilder("WFS returned an exception.");
            if (originatingRequest != null) {
                msg.append(" Originating Request: ");
                msg.append(originatingRequest.toString());
            }
            WFSException result = new WFSException(msg.toString());
            for (ExceptionType ex : exceptions) {
                result.addExceptionReport(ex.getExceptionCode() + ": " + String.valueOf(ex.getExceptionText()));
            }
            return result;
        }
        net.opengis.ows11.ExceptionReportType report = (net.opengis.ows11.ExceptionReportType)parsed;
        EList exceptions = report.getException();
        StringBuilder msg = new StringBuilder("WFS returned an exception.");
        if (originatingRequest != null) {
            msg.append(" Originating Request: ");
            msg.append(originatingRequest.toString());
        }
        WFSException result = new WFSException(msg.toString());
        for (net.opengis.ows11.ExceptionType ex : exceptions) {
            result.addExceptionReport(ex.getExceptionCode() + ": " + String.valueOf(ex.getExceptionText()));
        }
        return result;
    }

    @Override
    public boolean canProcess(WFSOperationType operation) {
        return WFSOperationType.GET_FEATURE.equals((Object)operation);
    }

    protected abstract GetFeatureParser parser(GetFeatureRequest var1, InputStream var2) throws IOException;

    protected abstract List<String> getSupportedVersions();
}

