/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec.db.oracle;

import org.geolatte.geom.Envelope;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.LLAPositionVisitor;
import org.geolatte.geom.Position;
import org.geolatte.geom.PositionSequence;
import org.geolatte.geom.PositionSequenceBuilder;
import org.geolatte.geom.PositionSequenceBuilders;
import org.geolatte.geom.cga.CircularArcLinearizer;
import org.geolatte.geom.codec.db.Decoder;
import org.geolatte.geom.codec.db.oracle.ElementType;
import org.geolatte.geom.codec.db.oracle.SDOGeometry;
import org.geolatte.geom.crs.CoordinateReferenceSystem;
import org.geolatte.geom.crs.CoordinateReferenceSystems;
import org.geolatte.geom.crs.CrsRegistry;
import org.geolatte.geom.crs.LinearUnit;

public abstract class AbstractSDODecoder
implements Decoder<SDOGeometry> {
    private static double LINEARIZER_EPSILON = 1.0E-4;
    private CoordinateReferenceSystem<?> crs;

    @Override
    public Geometry<?> decode(SDOGeometry nativeGeom) {
        if (!this.accepts(nativeGeom)) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + " received object of type " + nativeGeom.getGType());
        }
        this.crs = this.determineCRS(nativeGeom);
        return this.internalDecode(nativeGeom);
    }

    CoordinateReferenceSystem<?> getCoordinateReferenceSystem(SDOGeometry nativeGeom) {
        return this.crs;
    }

    private CoordinateReferenceSystem<?> determineCRS(SDOGeometry nativeGeom) {
        int srid = nativeGeom.getSRID();
        CoordinateReferenceSystem<?> crs = CrsRegistry.ifAbsentReturnProjected2D(srid);
        if (this.getVerticalDimension(nativeGeom) > 0) {
            crs = CoordinateReferenceSystems.addVerticalSystem(crs, LinearUnit.METER);
        }
        if (this.getLinearReferenceDimension(nativeGeom) > 0) {
            crs = CoordinateReferenceSystems.addLinearSystem(crs, LinearUnit.METER);
        }
        return crs;
    }

    int getCoordinateDimension(SDOGeometry nativeGeom) {
        return nativeGeom.getGType().getDimension();
    }

    int getLinearReferenceDimension(SDOGeometry nativeGeom) {
        return nativeGeom.getGType().getLRSDimension();
    }

    int getVerticalDimension(SDOGeometry nativeGeom) {
        return nativeGeom.getGType().getZDimension();
    }

    protected <P extends Position> PositionSequence<P> convertOrdinateArray(Double[] oordinates, SDOGeometry sdoGeom, CoordinateReferenceSystem<P> crs) {
        int dim = sdoGeom.getDimension();
        int numPos = oordinates.length / dim;
        PositionSequenceBuilder<double[]> sequenceBuilder = PositionSequenceBuilders.fixedSized(numPos, crs.getPositionClass());
        int zDim = sdoGeom.getZDimension() - 1;
        int lrsDim = sdoGeom.getLRSDimension() - 1;
        double[] buffer = new double[dim];
        for (int posIdx = 0; posIdx < numPos; ++posIdx) {
            int componentIdx = 0;
            buffer[componentIdx] = oordinates[posIdx * dim + componentIdx];
            buffer[++componentIdx] = oordinates[posIdx * dim + componentIdx];
            if (zDim > 0) {
                buffer[++componentIdx] = oordinates[posIdx * dim + zDim];
            }
            if (lrsDim > 0) {
                buffer[++componentIdx] = oordinates[posIdx * dim + lrsDim];
            }
            sequenceBuilder.add(buffer);
        }
        return sequenceBuilder.toPositionSequence();
    }

    protected <P extends Position> PositionSequence<P> add(PositionSequence<P> seq1, PositionSequence<P> seq2) {
        return this.add(seq1, 0, seq2, 0);
    }

    protected <P extends Position> PositionSequence<P> add(PositionSequence<P> seq1, int seq1Offset, PositionSequence<P> seq2, int seq2Offset) {
        if (seq1 == null) {
            return seq2;
        }
        if (seq2 == null) {
            return seq1;
        }
        int totalSize = seq1.size() - seq1Offset + seq2.size() - seq2Offset;
        PositionSequenceBuilder<P> builder = PositionSequenceBuilders.fixedSized(totalSize, seq1.getPositionClass());
        CombiningVisitor<P> visitor = new CombiningVisitor<P>(builder);
        this.addToBuilder(seq1, seq1Offset, builder, visitor);
        this.addToBuilder(seq2, seq2Offset, builder, visitor);
        return builder.toPositionSequence();
    }

    private <P extends Position> void addToBuilder(PositionSequence<P> seq, int skip, PositionSequenceBuilder<P> builder, CombiningVisitor<P> visitor) {
        if (skip == 0) {
            seq.accept(visitor);
        } else {
            for (Position pos : seq) {
                if (skip-- > 0) continue;
                builder.add(pos);
            }
        }
    }

    abstract Geometry<?> internalDecode(SDOGeometry var1);

    protected <P extends Position> PositionSequence<P> getCompoundCSeq(int idxFirst, int idxLast, SDOGeometry sdoGeom) {
        PositionSequence<?> cs = null;
        for (int i = idxFirst; i <= idxLast; ++i) {
            cs = cs != null && cs.size() > 0 ? this.add(cs, 0, this.getElementCSeq(i, sdoGeom, i < idxLast, this.crs), 1) : this.add(cs, this.getElementCSeq(i, sdoGeom, i < idxLast, this.crs));
        }
        return cs;
    }

    protected <P extends Position> PositionSequence<P> getElementCSeq(int i, SDOGeometry sdoGeom, boolean hasNextSE, CoordinateReferenceSystem<P> crs) {
        PositionSequence<P> cs;
        ElementType type = sdoGeom.getInfo().getElementType(i);
        Double[] elemOrdinates = this.extractOrdinatesOfElement(i, sdoGeom, hasNextSE);
        if (type.isStraightSegment()) {
            cs = this.convertOrdinateArray(elemOrdinates, sdoGeom, crs);
        } else if (type.isArcSegment() || type.isCircle()) {
            cs = this.linearize(this.convertOrdinateArray(elemOrdinates, sdoGeom, crs), type.isCircle());
        } else if (type.isRect()) {
            cs = this.convertOrdinateArray(elemOrdinates, sdoGeom, crs);
            cs = this.env2Seq(cs.getPositionN(0), cs.getPositionN(1), type.isExteriorRing());
        } else {
            throw new RuntimeException("Unexpected Element type in compound: " + (Object)((Object)type));
        }
        return cs;
    }

    private <P extends Position> PositionSequence<P> env2Seq(P p0, P p1, boolean asExteriorRing) {
        Envelope<P> env = new Envelope<P>(p0, p1, this.crs);
        if (asExteriorRing) {
            return PositionSequenceBuilders.fixedSized(5, this.crs.getPositionClass()).add(env.lowerLeft()).add(env.lowerRight()).add(env.upperRight()).add(env.upperLeft()).add(env.lowerLeft()).toPositionSequence();
        }
        return PositionSequenceBuilders.fixedSized(5, this.crs.getPositionClass()).add(env.lowerLeft()).add(env.upperLeft()).add(env.upperRight()).add(env.lowerRight()).add(env.lowerLeft()).toPositionSequence();
    }

    protected <P extends Position> PositionSequence<P> linearize(PositionSequence<P> positions, boolean entireCirlce) {
        PositionSequence<P> result = null;
        int idx = 0;
        while (idx < positions.size() - 2) {
            P p0 = positions.getPositionN(idx++);
            P p1 = positions.getPositionN(idx++);
            P p2 = positions.getPositionN(idx);
            CircularArcLinearizer<P> linearizer = new CircularArcLinearizer<P>(p0, p1, p2, LINEARIZER_EPSILON);
            PositionSequence<P> ps = entireCirlce ? linearizer.linearizeCircle() : linearizer.linearize();
            if (result == null) {
                result = ps;
                continue;
            }
            result = this.add(result, 0, ps, 1);
        }
        return result;
    }

    protected Double[] extractOrdinatesOfElement(int element, SDOGeometry sdoGeom, boolean hasNextSE) {
        int start = sdoGeom.getInfo().getOrdinatesOffset(element);
        if (element < sdoGeom.getInfo().getSize() - 1) {
            int end = sdoGeom.getInfo().getOrdinatesOffset(element + 1);
            if (hasNextSE) {
                end += sdoGeom.getDimension();
            }
            return sdoGeom.getOrdinates().getOrdinatesArray(start, end);
        }
        return sdoGeom.getOrdinates().getOrdinatesArray(start);
    }

    static class CombiningVisitor<P extends Position>
    implements LLAPositionVisitor {
        final PositionSequenceBuilder<P> builder;

        CombiningVisitor(PositionSequenceBuilder<P> builder) {
            this.builder = builder;
        }

        @Override
        public void visit(double[] coordinate) {
            this.builder.add(coordinate);
        }

        PositionSequence<P> result() {
            return this.builder.toPositionSequence();
        }
    }
}

