/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.crs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.geolatte.geom.Position;
import org.geolatte.geom.crs.CoordinateSystemAxis;
import org.geolatte.geom.crs.CoordinateSystemAxisDirection;
import org.geolatte.geom.crs.OneDimensionCoordinateSystem;
import org.geolatte.geom.crs.Unit;

public abstract class CoordinateSystem<P extends Position> {
    private final CoordinateSystemAxis[] axes;

    public CoordinateSystem(CoordinateSystemAxis ... axes) {
        if (axes == null || axes.length == 0) {
            throw new IllegalArgumentException("Requires at least 1 axis");
        }
        for (CoordinateSystemAxis axis : axes) {
            if (axis != null) continue;
            throw new IllegalArgumentException("Null axes are not allowed");
        }
        this.axes = axes;
    }

    public abstract Class<P> getPositionClass();

    public CoordinateSystemAxis[] getAxes() {
        return Arrays.copyOf(this.axes, this.axes.length);
    }

    public List<CoordinateSystemAxisDirection> getAxisDirections() {
        ArrayList<CoordinateSystemAxisDirection> directions = new ArrayList<CoordinateSystemAxisDirection>(this.axes.length);
        for (CoordinateSystemAxis a : this.axes) {
            directions.add(a.getAxisDirection());
        }
        return directions;
    }

    public List<Integer> getAxisNormalOrder() {
        ArrayList<Integer> order = new ArrayList<Integer>(this.axes.length);
        for (CoordinateSystemAxis a : this.axes) {
            order.add(a.getNormalOrder());
        }
        return order;
    }

    public int getCoordinateDimension() {
        return this.axes.length;
    }

    public int getAxisIndex(CoordinateSystemAxis axis) {
        int i = 0;
        for (CoordinateSystemAxis a : this.axes) {
            if (a.equals(axis)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public CoordinateSystemAxis getAxisForComponentIndex(int i) {
        List<Integer> order = this.getAxisNormalOrder();
        int oIdx = order.get(i);
        for (CoordinateSystemAxis a : this.axes) {
            if (a.getAxisDirection().defaultNormalOrder != oIdx) continue;
            return a;
        }
        throw new IllegalStateException();
    }

    public CoordinateSystemAxis getAxis(int index) {
        return this.axes[index];
    }

    public Unit getAxisUnit(int index) {
        return this.axes[index].getUnit();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoordinateSystem that = (CoordinateSystem)o;
        return Arrays.equals(this.axes, that.axes);
    }

    public int hashCode() {
        return Arrays.hashCode(this.axes);
    }

    public abstract CoordinateSystem<?> merge(OneDimensionCoordinateSystem<?> var1);

    public abstract CoordinateSystem<?> extend(CoordinateSystemAxis var1);
}

