/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.internal;

import net.opengis.wfs20.WFSCapabilitiesType;
import org.eclipse.emf.ecore.EObject;
import org.geotools.data.ows.Capabilities;
import org.geotools.xml.EMFUtils;
import org.w3c.dom.Document;

public class WFSGetCapabilities
extends Capabilities {
    protected final Document rawDocument;
    protected final EObject capabilities;

    private WFSGetCapabilities(EObject capabilities, Document rawDocument) {
        this.capabilities = capabilities;
        this.rawDocument = rawDocument;
        try {
            String updateSequence = (String)EMFUtils.get((EObject)capabilities, (String)"updateSequence");
            this.setUpdateSequence(updateSequence);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Document getRawDocument() {
        return this.rawDocument;
    }

    public EObject getParsedCapabilities() {
        return this.capabilities;
    }

    public static WFSGetCapabilities create(EObject capabilities, Document rawDocument) {
        if (capabilities instanceof net.opengis.wfs.WFSCapabilitiesType) {
            net.opengis.wfs.WFSCapabilitiesType caps = (net.opengis.wfs.WFSCapabilitiesType)capabilities;
            String version = rawDocument.getDocumentElement().getAttribute("version");
            if ("1.0.0".equals(version)) {
                return new WFS_1_0_0(caps, rawDocument);
            }
            if ("1.1.0".equals(version)) {
                return new WFS_1_1_0(caps, rawDocument);
            }
            throw new IllegalArgumentException("Unknown version: " + version);
        }
        if (capabilities instanceof WFSCapabilitiesType) {
            return new WFS_2_0_0((WFSCapabilitiesType)capabilities, rawDocument);
        }
        throw new IllegalArgumentException("Unrecognized capabilities object: " + capabilities);
    }

    private static class WFS_2_0_0
    extends WFSGetCapabilities {
        public WFS_2_0_0(WFSCapabilitiesType capabilities, Document rawDocument) {
            super((EObject)capabilities, rawDocument);
            this.setVersion("2.0.0");
        }
    }

    private static class WFS_1_1_0
    extends WFSGetCapabilities {
        public WFS_1_1_0(net.opengis.wfs.WFSCapabilitiesType capabilities, Document rawDocument) {
            super((EObject)capabilities, rawDocument);
            this.setVersion("1.1.0");
        }
    }

    private static class WFS_1_0_0
    extends WFSGetCapabilities {
        public WFS_1_0_0(net.opengis.wfs.WFSCapabilitiesType caps, Document rawDocument) {
            super((EObject)caps, rawDocument);
            this.setVersion("1.0.0");
        }
    }
}

