/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml;

import java.io.IOException;
import java.util.Set;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.util.XSDSchemaLocator;
import org.geotools.xml.AppSchemaConfiguration;
import org.geotools.xml.AppSchemaLocationResolver;
import org.geotools.xml.AppSchemaXSDRegistry;
import org.geotools.xml.Configuration;
import org.geotools.xml.SchemaLocationResolver;
import org.geotools.xml.SchemaLocator;
import org.geotools.xml.XSD;
import org.geotools.xml.resolver.SchemaResolver;

public class AppSchemaXSD
extends XSD {
    private final String namespaceUri;
    private final String schemaLocation;
    private final SchemaResolver resolver;
    private AppSchemaConfiguration configuration;

    public AppSchemaXSD(String namespaceUri, String schemaLocation, SchemaResolver resolver) {
        this.namespaceUri = namespaceUri;
        this.schemaLocation = resolver.resolve(schemaLocation);
        this.resolver = resolver;
    }

    public String getNamespaceURI() {
        return this.namespaceUri;
    }

    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setConfiguration(AppSchemaConfiguration configuration) {
        this.configuration = configuration;
    }

    public SchemaLocationResolver createSchemaLocationResolver() {
        return new AppSchemaLocationResolver(this.resolver);
    }

    protected void addDependencies(Set dependencies) {
        if (this.configuration != null) {
            for (Configuration dependency : this.configuration.getDependencies()) {
                dependencies.add(dependency.getXSD());
            }
        }
    }

    public SchemaLocator createSchemaLocator() {
        return new SchemaLocator(this){

            public boolean canHandle(XSDSchema schema, String namespaceURI, String rawSchemaLocationURI, String resolvedSchemaLocationURI) {
                return this.xsd.getNamespaceURI().equals(namespaceURI) && this.xsd.getSchemaLocation().equals(resolvedSchemaLocationURI);
            }
        };
    }

    public XSDSchemaLocator getSupplementarySchemaLocator() {
        return AppSchemaXSDRegistry.getInstance();
    }

    protected XSDSchema buildSchema() throws IOException {
        XSDSchema schema = AppSchemaXSDRegistry.getInstance().lookUp(this.schemaLocation);
        if (schema == null) {
            schema = super.buildSchema();
            AppSchemaXSDRegistry.getInstance().register(schema);
        } else {
            schema.reset();
        }
        return schema;
    }
}

