/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex.config;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.geotools.xml.AppSchemaConfiguration;
import org.geotools.xml.Configuration;
import org.geotools.xml.SchemaIndex;
import org.geotools.xml.Schemas;
import org.geotools.xml.resolver.SchemaCatalog;
import org.geotools.xml.resolver.SchemaResolver;
import org.xmlpull.mxp1.MXParser;

public class EmfComplexFeatureReader {
    private SchemaResolver resolver = new SchemaResolver();

    protected EmfComplexFeatureReader() {
    }

    public SchemaResolver getResolver() {
        return this.resolver;
    }

    public void setResolver(SchemaResolver resolver) {
        this.resolver = resolver;
    }

    public void setResolver(URL catalogLocation) {
        this.resolver = new SchemaResolver(SchemaCatalog.build(catalogLocation));
    }

    public SchemaIndex parse(Configuration configuration) throws IOException {
        SchemaIndex appSchemaIndex = Schemas.findSchemas((Configuration)configuration);
        return appSchemaIndex;
    }

    public SchemaIndex parse(String nameSpace, String schemaLocation) throws IOException {
        AppSchemaConfiguration configuration = new AppSchemaConfiguration(nameSpace, schemaLocation, this.resolver);
        return this.parse((Configuration)configuration);
    }

    public SchemaIndex parse(URL location) throws IOException {
        String nameSpace = this.findSchemaNamespace(location);
        String schemaLocation = location.toExternalForm();
        return this.parse(nameSpace, schemaLocation);
    }

    public String findSchemaNamespace(URL location) throws IOException {
        String targetNamespace = null;
        URL resolvedLocation = new URL(this.resolver.resolve(location.toExternalForm()));
        MXParser parser = null;
        try (InputStream input = resolvedLocation.openStream();){
            parser = new MXParser();
            parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            parser.setInput(input, "UTF-8");
            parser.nextTag();
            for (int i = 0; i < parser.getAttributeCount(); ++i) {
                if (!"targetNamespace".equals(parser.getAttributeName(i))) continue;
                targetNamespace = parser.getAttributeValue(i);
                break;
            }
            parser.setInput(null);
        }
        if (targetNamespace == null) {
            throw new IllegalArgumentException("Input document does not specifies a targetNamespace");
        }
        return targetNamespace;
    }

    public static EmfComplexFeatureReader newInstance() {
        return new EmfComplexFeatureReader();
    }
}

