/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings;

import com.vividsolutions.jts.geom.CoordinateSequence;
import java.math.BigInteger;
import javax.xml.namespace.QName;
import org.geotools.geometry.DirectPosition1D;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.DirectPosition3D;
import org.geotools.geometry.jts.coordinatesequence.CoordinateSequences;
import org.geotools.gml3.GML;
import org.geotools.gml3.bindings.GML3ParsingUtils;
import org.geotools.xml.AbstractComplexBinding;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.Node;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DirectPositionListTypeBinding
extends AbstractComplexBinding {
    public QName getTarget() {
        return GML.DirectPositionListType;
    }

    public int getExecutionMode() {
        return 0;
    }

    public Class getType() {
        return CoordinateSequence.class;
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        int coordCount;
        int crsDimension = GML3ParsingUtils.dimensions(node);
        CoordinateReferenceSystem crs = GML3ParsingUtils.crs(node);
        Double[] values = (Double[])value;
        BigInteger coordinatesCount = (BigInteger)node.getAttributeValue("count");
        if (coordinatesCount == null) {
            coordinatesCount = BigInteger.valueOf(values.length / crsDimension);
        }
        if ((coordCount = coordinatesCount.intValue()) == 0) {
            return new DirectPosition[0];
        }
        int dim = values.length / coordCount;
        if (dim < 1) {
            throw new IllegalArgumentException("dimension must be greater or equal to 1");
        }
        DirectPosition[] dps = new DirectPosition[coordCount];
        if (dim == 1) {
            for (int i = 0; i < coordCount; ++i) {
                dps[i] = new DirectPosition1D(crs);
                dps[i].setOrdinate(0, values[i].doubleValue());
            }
        } else if (dim == 2) {
            int ordinateIdx = 0;
            for (int coordIndex = 0; coordIndex < coordCount; ++coordIndex) {
                dps[coordIndex] = new DirectPosition2D(crs);
                dps[coordIndex].setOrdinate(0, values[ordinateIdx].doubleValue());
                dps[coordIndex].setOrdinate(1, values[ordinateIdx + 1].doubleValue());
                ordinateIdx += crsDimension;
            }
        } else {
            int ordinateIdx = 0;
            for (int coordIndex = 0; coordIndex < coordCount; ++coordIndex) {
                dps[coordIndex] = new DirectPosition3D(crs);
                dps[coordIndex].setOrdinate(0, values[ordinateIdx].doubleValue());
                dps[coordIndex].setOrdinate(1, values[ordinateIdx + 1].doubleValue());
                dps[coordIndex].setOrdinate(2, values[ordinateIdx + 2].doubleValue());
                ordinateIdx += crsDimension;
            }
        }
        return dps;
    }

    public Element encode(Object object, Document document, Element value) throws Exception {
        CoordinateSequence cs = (CoordinateSequence)object;
        StringBuffer sb = new StringBuffer();
        int dim = CoordinateSequences.coordinateDimension((CoordinateSequence)cs);
        int size = cs.size();
        int nOrdWithSpace = size * dim - 1;
        int count = 0;
        for (int i = 0; i < size; ++i) {
            for (int d = 0; d < dim; ++d) {
                sb.append(cs.getOrdinate(i, d));
                if (count < nOrdWithSpace) {
                    sb.append(" ");
                }
                ++count;
            }
        }
        value.appendChild(document.createTextNode(sb.toString()));
        return value;
    }
}

