/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.io.input;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class BitInputStream
extends FilterInputStream {
    private int bitBuf = 0;
    private int bitPos = 0;

    public BitInputStream(InputStream in) {
        super(in);
    }

    public int readUI8() throws IOException {
        int ui8 = this.in.read();
        if (ui8 < 0) {
            throw new IOException("BitInputStream::readUI8:End of input.");
        }
        return ui8;
    }

    public int[] readUI8(int length) throws IOException {
        int[] data = new int[length];
        int read = 0;
        for (int i = 0; i < length && read >= 0; ++i) {
            data[i] = read = this.read();
        }
        if (read < 0) {
            throw new IOException("BitInputStream::readUI8(final int length): of input.");
        }
        return data;
    }

    public byte[] read(int length) throws IOException {
        int numReadRetry;
        byte[] data = new byte[length];
        int numRead = this.read(data);
        if (numRead < length && numRead + (numReadRetry = this.read(data, numRead, data.length - numRead)) < length) {
            throw new IOException("BitInputStream::read(final int length):Unexpected end of input.");
        }
        return data;
    }

    public long readUBits(int numBits) throws IOException {
        if (numBits == 0) {
            return 0L;
        }
        int bitsLeft = numBits;
        long result = 0L;
        if (this.bitPos == 0) {
            this.bitBuf = this.in.read();
            this.bitPos = 8;
        }
        int shift = 0;
        while ((shift = bitsLeft - this.bitPos) > 0) {
            result |= (long)(this.bitBuf << shift);
            bitsLeft -= this.bitPos;
            this.bitBuf = this.in.read();
            this.bitPos = 8;
        }
        this.bitPos -= bitsLeft;
        this.bitBuf &= 255 >> 8 - this.bitPos;
        return result |= (long)(this.bitBuf >> -shift);
    }

    public int readSBits(int numBits) throws IOException {
        long uBits = this.readUBits(numBits);
        if ((uBits & 1L << numBits - 1) != 0L) {
            uBits |= -1L << numBits;
        }
        return (int)uBits;
    }
}

