/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.topnl;

import com.vividsolutions.jts.io.ParseException;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.sql.SQLException;
import javax.sql.DataSource;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import nl.b3p.topnl.Processor;
import nl.b3p.topnl.TopNLType;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom2.JDOMException;
import org.xml.sax.SAXException;

public class Main {
    protected static final Log log = LogFactory.getLog(Main.class);

    public static void main(String[] args) throws IOException, JAXBException, ParseException, SQLException, JDOMException {
        try {
            BasicDataSource ds = new BasicDataSource();
            ds.setUrl("jdbc:postgresql://localhost:5432/topnl");
            ds.setDriverClassName("org.postgresql.Driver");
            ds.setUsername("rsgb");
            ds.setPassword("rsgb");
            Processor p = new Processor((DataSource)ds);
            Main.loadtopnl("/mnt/data/Documents/TopNL/Tynaarlo/Top10NL", p, TopNLType.TOP10NL);
        }
        catch (ParserConfigurationException | TransformerException | SAXException ex) {
            log.error((Object)"Cannot parse/convert/save entity: ", (Throwable)ex);
        }
    }

    private static void loadtopnl(String dir, Processor p, TopNLType type) throws ParseException, IOException, SAXException, ParserConfigurationException, JAXBException, TransformerException, JDOMException {
        File[] files;
        File f = new File(dir);
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".gml");
            }
        };
        for (File file : files = f.listFiles(filter)) {
            String fileString = file.getCanonicalPath();
            p.importIntoDb(file.toURL(), type);
        }
    }

    private static void process(String file, Processor p, TopNLType type) throws ParseException, IOException, SAXException, ParserConfigurationException, JAXBException, TransformerException, JDOMException {
        URL in = Main.class.getResource(file);
        p.importIntoDb(in, type);
        boolean a = false;
    }
}

