/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.sqlserver.jtds;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.sqlserver.SQLServerDataStoreFactory;
import org.geotools.data.sqlserver.jtds.JTDSSQLServerDialect;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.SQLDialect;

public class JTDSSqlServerDataStoreFactory
extends SQLServerDataStoreFactory {
    public static final DataAccessFactory.Param DBTYPE = new DataAccessFactory.Param("dbtype", String.class, "Type", true, (Object)"jtds-sqlserver", Collections.singletonMap("level", "program"));

    @Override
    public String getDescription() {
        return "Microsoft SQL Server (JTDS Driver)";
    }

    @Override
    protected SQLDialect createSQLDialect(JDBCDataStore dataStore) {
        return new JTDSSQLServerDialect(dataStore);
    }

    @Override
    protected String getDriverClassName() {
        return "net.sourceforge.jtds.jdbc.Driver";
    }

    @Override
    protected String getDatabaseID() {
        return (String)JTDSSqlServerDataStoreFactory.DBTYPE.sample;
    }

    @Override
    protected String getJDBCUrl(Map params) throws IOException {
        Boolean intsec;
        String host = (String)HOST.lookUp(params);
        Integer port = (Integer)PORT.lookUp(params);
        String db = (String)DATABASE.lookUp(params);
        String instance = (String)INSTANCE.lookUp(params);
        String url = "jdbc:jtds:sqlserver://" + host;
        if (port != null) {
            url = url + ":" + port;
        }
        if (db != null) {
            url = url + "/" + db;
        }
        if (instance != null) {
            url = url + ";instance=" + instance;
        }
        if ((intsec = (Boolean)INTSEC.lookUp(params)) != null && intsec.booleanValue()) {
            url = url + ";integratedSecurity=true";
        }
        return url;
    }
}

