/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.colorindexer;

public final class ColorUtils {
    public static int alpha(int color) {
        return color >> 24 & 0xFF;
    }

    public static int red(int color) {
        return color >> 16 & 0xFF;
    }

    public static int green(int color) {
        return color >> 8 & 0xFF;
    }

    public static int blue(int color) {
        return color & 0xFF;
    }

    public static int color(int red, int green, int blue, int alpha) {
        return (alpha & 0xFF) << 24 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | (blue & 0xFF) << 0;
    }

    public static int shift(int component, int shift) {
        return component >> shift;
    }

    public static int unshift(int component, int shift) {
        if (component == 0) {
            return 0;
        }
        int shiftedMax = 255 >> shift;
        if (component == shiftedMax) {
            return 255;
        }
        return (component * 255 + shiftedMax / 2) / shiftedMax;
    }

    public static int compareLong(long l1, long l2) {
        long diff = l1 - l2;
        if (diff == 0L) {
            return 0;
        }
        if (diff > 0L) {
            return 1;
        }
        return -1;
    }
}

