/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.callback.async;

import java.lang.reflect.Method;
import org.javasimon.callback.Callback;
import org.javasimon.callback.async.Executor;
import org.javasimon.callback.async.ExecutorProxyFactory;
import org.javasimon.proxy.Delegating;
import org.javasimon.proxy.DelegatingMethodInvocation;

public final class AsyncCallbackProxyFactory
extends ExecutorProxyFactory<Callback> {
    private static final Class[] PROXY_INTERFACES = new Class[]{Callback.class, Delegating.class};
    private final Method getDelegateMethod = this.findGetDelegateMethod();

    public AsyncCallbackProxyFactory(Callback delegate) {
        super(delegate);
    }

    public AsyncCallbackProxyFactory(Callback delegate, Executor executor) {
        super(delegate, executor);
    }

    private Method findGetDelegateMethod() {
        try {
            return Delegating.class.getDeclaredMethod("getDelegate", new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException noSuchMethodException) {
            throw new IllegalStateException("getDelegate method not found on Delegating interface", noSuchMethodException);
        }
    }

    public Callback newProxy(ClassLoader classLoader) {
        return (Callback)this.newProxy(classLoader, PROXY_INTERFACES);
    }

    public Callback newProxy() {
        return (Callback)this.newProxy(PROXY_INTERFACES);
    }

    @Override
    protected Object invoke(DelegatingMethodInvocation<Callback> delegatingMethodInvocation) throws Throwable {
        Object result = delegatingMethodInvocation.getMethod().equals(this.getDelegateMethod) ? this.getDelegate() : super.invoke(delegatingMethodInvocation);
        return result;
    }
}

