/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.jmx;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.javasimon.Counter;
import org.javasimon.CounterSample;
import org.javasimon.Manager;
import org.javasimon.Simon;
import org.javasimon.SimonException;
import org.javasimon.SimonPattern;
import org.javasimon.SimonState;
import org.javasimon.Stopwatch;
import org.javasimon.StopwatchSample;
import org.javasimon.jmx.SimonInfo;
import org.javasimon.jmx.SimonManagerMXBean;
import org.javasimon.utils.SimonUtils;

public class SimonManagerMXBeanImpl
implements SimonManagerMXBean {
    private Manager manager;

    public SimonManagerMXBeanImpl(Manager manager) {
        this.manager = manager;
    }

    @Override
    public final void enable() {
        this.manager.enable();
    }

    @Override
    public final void disable() {
        this.manager.disable();
    }

    @Override
    public final boolean isEnabled() {
        return this.manager.isEnabled();
    }

    @Override
    public final String[] getSimonNames() {
        Collection<String> simonNames = this.manager.getSimonNames();
        return simonNames.toArray(new String[simonNames.size()]);
    }

    @Override
    public final String[] getSimonNamesOrdered() {
        Object[] simonNames = this.getSimonNames();
        Arrays.sort(simonNames);
        return simonNames;
    }

    @Override
    public final String getType(String name) {
        Simon s = this.manager.getSimon(name);
        return s != null ? (s instanceof Stopwatch ? "Stopwatch" : "Counter") : null;
    }

    @Override
    public final SimonInfo[] getSimonInfos() {
        String[] simonNames = this.getSimonNamesOrdered();
        SimonInfo[] simonInfo = new SimonInfo[simonNames.length];
        int i = 0;
        for (String name : simonNames) {
            Simon s = this.manager.getSimon(name);
            simonInfo[i++] = new SimonInfo(name, s instanceof Stopwatch ? "Stopwatch" : (s instanceof Counter ? "Counter" : "Unknown"));
        }
        return simonInfo;
    }

    @Override
    public final void clearManager() {
        this.manager.clear();
    }

    @Override
    public final void enableSimon(String name) {
        this.setSimonState(name, SimonState.ENABLED);
    }

    private void setSimonState(String name, SimonState newState) {
        Simon simon = this.manager.getSimon(name);
        if (simon == null) {
            throw new SimonException("Unknown Simon: " + name);
        }
        simon.setState(newState, false);
    }

    @Override
    public final void disableSimon(String name) {
        this.setSimonState(name, SimonState.DISABLED);
    }

    @Override
    public final void inheritState(String name) {
        this.setSimonState(name, SimonState.INHERIT);
    }

    private org.javasimon.jmx.CounterSample sampleCounter(Simon counter) {
        return new org.javasimon.jmx.CounterSample((CounterSample)counter.sample());
    }

    @Override
    public final org.javasimon.jmx.CounterSample getCounterSample(String name) {
        Counter counter = this.getSimonOfType(name, Counter.class);
        return this.sampleCounter(counter);
    }

    private <T extends Simon> T getSimonOfType(String name, Class<T> simonType) {
        Simon simon = this.manager.getSimon(name);
        if (simon == null) {
            throw new SimonException("Unknown Simon: " + name);
        }
        if (!simonType.isInstance(simon)) {
            throw new SimonException("Wrong Simon type");
        }
        return (T)((Simon)simonType.cast(simon));
    }

    @Override
    public org.javasimon.jmx.CounterSample getIncrementCounterSample(String name, String key) {
        Counter counter = this.getSimonOfType(name, Counter.class);
        return new org.javasimon.jmx.CounterSample(counter.sampleIncrement(key));
    }

    @Override
    public List<org.javasimon.jmx.CounterSample> getCounterSamples(String namePattern) {
        ArrayList<org.javasimon.jmx.CounterSample> counterSamples = new ArrayList<org.javasimon.jmx.CounterSample>();
        for (Simon simon : this.manager.getSimons(SimonPattern.createForCounter(namePattern))) {
            counterSamples.add(this.sampleCounter(simon));
        }
        return counterSamples;
    }

    @Override
    public List<org.javasimon.jmx.CounterSample> getIncrementCounterSamples(String namePattern, String key) {
        ArrayList<org.javasimon.jmx.CounterSample> counterSamples = new ArrayList<org.javasimon.jmx.CounterSample>();
        for (Simon simon : this.manager.getSimons(SimonPattern.createForCounter(namePattern))) {
            Counter counter = (Counter)simon;
            counterSamples.add(new org.javasimon.jmx.CounterSample(counter.sampleIncrement(key)));
        }
        return counterSamples;
    }

    @Override
    public List<org.javasimon.jmx.CounterSample> getCounterSamples() {
        return this.getCounterSamples(null);
    }

    @Override
    public List<org.javasimon.jmx.CounterSample> getIncrementCounterSamples(String key) {
        return this.getIncrementCounterSamples(null, key);
    }

    private org.javasimon.jmx.StopwatchSample sampleStopwatch(Simon s) {
        return new org.javasimon.jmx.StopwatchSample((StopwatchSample)s.sample());
    }

    @Override
    public final org.javasimon.jmx.StopwatchSample getStopwatchSample(String name) {
        Stopwatch stopwatch = this.getSimonOfType(name, Stopwatch.class);
        return this.sampleStopwatch(stopwatch);
    }

    @Override
    public org.javasimon.jmx.StopwatchSample getIncrementStopwatchSample(String name, String key) {
        Stopwatch stopwatch = this.getSimonOfType(name, Stopwatch.class);
        return new org.javasimon.jmx.StopwatchSample(stopwatch.sampleIncrement(key));
    }

    @Override
    public List<org.javasimon.jmx.StopwatchSample> getStopwatchSamples(String namePattern) {
        ArrayList<org.javasimon.jmx.StopwatchSample> stopwatchSamples = new ArrayList<org.javasimon.jmx.StopwatchSample>();
        for (Simon simon : this.manager.getSimons(SimonPattern.createForStopwatch(namePattern))) {
            stopwatchSamples.add(this.sampleStopwatch(simon));
        }
        return stopwatchSamples;
    }

    @Override
    public List<org.javasimon.jmx.StopwatchSample> getIncrementStopwatchSamples(String namePattern, String key) {
        ArrayList<org.javasimon.jmx.StopwatchSample> stopwatchSamples = new ArrayList<org.javasimon.jmx.StopwatchSample>();
        for (Simon simon : this.manager.getSimons(SimonPattern.createForStopwatch(namePattern))) {
            Stopwatch stopwatch = (Stopwatch)simon;
            stopwatchSamples.add(new org.javasimon.jmx.StopwatchSample(stopwatch.sampleIncrement(key)));
        }
        return stopwatchSamples;
    }

    @Override
    public List<org.javasimon.jmx.StopwatchSample> getStopwatchSamples() {
        return this.getStopwatchSamples(null);
    }

    @Override
    public List<org.javasimon.jmx.StopwatchSample> getIncrementStopwatchSamples(String key) {
        return this.getIncrementStopwatchSamples(null, key);
    }

    @Override
    public final void printSimonTree() {
        System.out.println(SimonUtils.simonTreeString(this.manager.getRootSimon()));
    }

    Manager getManager() {
        return this.manager;
    }
}

