/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.parameter;

import java.util.Map;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.wkt.Formatter;
import org.geotools.resources.i18n.Errors;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.referencing.IdentifiedObject;

public abstract class AbstractParameterDescriptor
extends AbstractIdentifiedObject
implements GeneralParameterDescriptor {
    private static final long serialVersionUID = -2630644278783845276L;
    private final int minimumOccurs;

    protected AbstractParameterDescriptor(GeneralParameterDescriptor descriptor) {
        super((IdentifiedObject)descriptor);
        this.minimumOccurs = descriptor.getMinimumOccurs();
    }

    protected AbstractParameterDescriptor(Map<String, ?> properties, int minimumOccurs, int maximumOccurs) {
        super(properties);
        this.minimumOccurs = minimumOccurs;
        if (minimumOccurs < 0 || maximumOccurs < minimumOccurs) {
            throw new IllegalArgumentException(Errors.format(14, minimumOccurs, maximumOccurs));
        }
    }

    public abstract GeneralParameterValue createValue();

    public int getMinimumOccurs() {
        return this.minimumOccurs;
    }

    public abstract int getMaximumOccurs();

    @Override
    public boolean equals(AbstractIdentifiedObject object, boolean compareMetadata) {
        if (super.equals(object, compareMetadata)) {
            AbstractParameterDescriptor that = (AbstractParameterDescriptor)object;
            return this.minimumOccurs == that.minimumOccurs;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 0x58ACDC64 ^ this.minimumOccurs;
    }

    @Override
    protected String formatWKT(Formatter formatter) {
        formatter.setInvalidWKT(GeneralParameterDescriptor.class);
        return "PARAMETER";
    }
}

